/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.exporter;

import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.beangle.commons.transfer.Transfer;
import org.beangle.commons.transfer.TransferListener;
import org.beangle.commons.transfer.TransferResult;
import org.beangle.commons.transfer.exporter.Context;
import org.beangle.commons.transfer.exporter.Exporter;
import org.beangle.commons.transfer.io.ItemWriter;
import org.beangle.commons.transfer.io.TransferFormat;
import org.beangle.commons.transfer.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractItemExporter
implements Exporter {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractItemExporter.class);
    protected ItemWriter writer;
    protected TransferResult transferResult;
    protected Vector<TransferListener> listeners = new Vector();
    protected int success = 0;
    protected int fail = 0;
    protected int index = -1;
    protected Collection<?> datas;
    protected Iterator<?> iter;
    private Object current;
    protected Context context;

    @Override
    public Transfer addListener(TransferListener listener) {
        this.listeners.add(listener);
        listener.setTransfer(this);
        return this;
    }

    @Override
    public Object getCurrent() {
        return this.current;
    }

    @Override
    public int getFail() {
        return this.fail;
    }

    @Override
    public Locale getLocale() {
        return Locale.getDefault();
    }

    @Override
    public int getSuccess() {
        return this.success;
    }

    @Override
    public int getTranferIndex() {
        return this.index;
    }

    @Override
    public void transfer(TransferResult tr) {
        this.transferResult = tr;
        tr.setTransfer(this);
        if (!this.beforeExport()) {
            return;
        }
        for (TransferListener listener : this.listeners) {
            listener.onStart(tr);
        }
        while (this.hasNext()) {
            this.next();
            int errors = tr.errors();
            for (TransferListener listener : this.listeners) {
                listener.onItemStart(tr);
            }
            long transferItemStart = System.currentTimeMillis();
            this.transferItem();
            if (tr.errors() == errors) {
                ++this.success;
            } else {
                ++this.fail;
            }
            logger.debug("tranfer item:{}  take time:{}", (Object)String.valueOf(this.getTranferIndex()), (Object)String.valueOf(System.currentTimeMillis() - transferItemStart));
            for (TransferListener listener : this.listeners) {
                listener.onItemFinish(tr);
            }
        }
        for (TransferListener listener : this.listeners) {
            listener.onFinish(tr);
        }
        this.writer.close();
    }

    protected boolean beforeExport() {
        return true;
    }

    @Override
    public void transferItem() {
        if (null == this.getCurrent()) {
            return;
        }
        this.writer.write(this.getCurrent());
    }

    protected void next() {
        ++this.index;
        this.current = this.iter.next();
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public TransferFormat getFormat() {
        return this.writer.getFormat();
    }

    @Override
    public void setContext(Context context) {
        Collection items = (Collection)context.getDatas().get("items");
        if (null != items) {
            this.datas = items;
            this.iter = this.datas.iterator();
        }
        this.context = context;
    }

    @Override
    public String getDataName() {
        return null;
    }

    @Override
    public void setWriter(Writer writer) {
        if (writer instanceof ItemWriter) {
            this.writer = (ItemWriter)writer;
        }
    }

    @Override
    public ItemWriter getWriter() {
        return this.writer;
    }
}

