/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.commons.transfer.exporter;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.bean.PropertyUtils;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.text.i18n.TextResource;
import org.beangle.commons.transfer.exporter.PropertyExtractor;

public class DefaultPropertyExtractor
implements PropertyExtractor {
    protected TextResource textResource = null;
    protected Set<String> errorProperties = CollectUtils.newHashSet();

    public DefaultPropertyExtractor() {
    }

    public DefaultPropertyExtractor(TextResource textResource) {
        this.setTextResource(textResource);
    }

    protected Object extract(Object target, String property) throws Exception {
        if (this.errorProperties.contains(property)) {
            return null;
        }
        if (target instanceof Map) {
            return ((Map)target).get(property);
        }
        Object value = PropertyUtils.getProperty((Object)target, (String)property);
        if (value instanceof Boolean) {
            if (null == this.textResource) {
                return value;
            }
            if (Boolean.TRUE.equals(value)) {
                return this.getText("common.yes", "Y");
            }
            return this.getText("common.no", "N");
        }
        return value;
    }

    @Override
    public Object getPropertyValue(Object target, String property) throws Exception {
        return this.extract(target, property);
    }

    public String getPropertyIn(Collection<?> collection, String property) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (null != collection) {
            for (Object one : collection) {
                sb.append(this.extract(one, property)).append(",");
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected String getText(String key) {
        return this.textResource.getText(key, key, new Object[0]);
    }

    protected String getText(String key, String defaultVal) {
        return this.textResource.getText(key, defaultVal, new Object[0]);
    }

    @Override
    public TextResource getTextResource() {
        return this.textResource;
    }

    @Override
    public void setTextResource(TextResource textResource) {
        this.textResource = textResource;
    }
}

