/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.inject.spring.config;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.inject.bind.BindRegistry;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.time.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.util.ClassUtils;

public class SpringBindRegistry
implements BindRegistry {
    private static final Logger logger = LoggerFactory.getLogger(SpringBindRegistry.class);
    protected Map<String, Class<?>> nameTypes = CollectUtils.newHashMap();
    protected Map<Class<?>, List<String>> typeNames = CollectUtils.newHashMap();
    protected final BeanDefinitionRegistry definitionRegistry;

    public Set<String> getBeanNames() {
        return this.nameTypes.keySet();
    }

    public SpringBindRegistry(BeanDefinitionRegistry registry) {
        Stopwatch watch = new Stopwatch(true);
        this.definitionRegistry = registry;
        for (String name : registry.getBeanDefinitionNames()) {
            BeanDefinition bd = registry.getBeanDefinition(name);
            if (bd.isAbstract()) continue;
            String className = bd.getBeanClassName();
            if (null == className) {
                String parentName = bd.getParentName();
                if (null == parentName) continue;
                BeanDefinition parentDef = registry.getBeanDefinition(parentName);
                className = parentDef.getBeanClassName();
            }
            if (null == className) continue;
            try {
                Class beanClass = ClassUtils.forName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
                if (FactoryBean.class.isAssignableFrom(beanClass)) {
                    String nestedClassName;
                    this.register(beanClass, "&" + name, new Object[0]);
                    PropertyValue pv = bd.getPropertyValues().getPropertyValue("target");
                    if (null == pv) {
                        Class artifactClass = ((FactoryBean)beanClass.newInstance()).getObjectType();
                        if (null == artifactClass) continue;
                        this.register(artifactClass, name, new Object[0]);
                        continue;
                    }
                    if (!(pv.getValue() instanceof BeanDefinitionHolder) || null == (nestedClassName = ((BeanDefinitionHolder)pv.getValue()).getBeanDefinition().getBeanClassName())) continue;
                    this.register(ClassUtils.forName((String)nestedClassName, (ClassLoader)ClassUtils.getDefaultClassLoader()), name, new Object[0]);
                    continue;
                }
                this.register(beanClass, name, new Object[0]);
            }
            catch (Exception e) {
                logger.error("class not found", (Throwable)e);
            }
        }
        logger.info("Init registry ({} beans) in {}", (Object)this.nameTypes.size(), (Object)watch);
    }

    public List<String> getBeanNames(Class<?> type) {
        if (this.typeNames.containsKey(type)) {
            return this.typeNames.get(type);
        }
        List names = CollectUtils.newArrayList();
        for (Map.Entry<String, Class<?>> entry : this.nameTypes.entrySet()) {
            if (!type.isAssignableFrom(entry.getValue())) continue;
            names.add(entry.getKey());
        }
        this.typeNames.put(type, names);
        return names;
    }

    public Class<?> getBeanType(String beanName) {
        return this.nameTypes.get(beanName);
    }

    public boolean contains(String beanName) {
        return this.nameTypes.containsKey(beanName);
    }

    public void register(Class<?> type, String name, Object ... args) {
        Assert.notNull((Object)name, (String)"class'name is null", (Object[])new Object[0]);
        if (0 == args.length) {
            this.nameTypes.put(name, type);
        } else {
            BeanDefinition bd = (BeanDefinition)args[0];
            this.definitionRegistry.registerBeanDefinition(name, bd);
            String alias = bd.getBeanClassName();
            if (bd.isSingleton() && !name.equals(alias) && !this.definitionRegistry.isBeanNameInUse(alias)) {
                this.definitionRegistry.registerAlias(name, alias);
            }
            if (null == type) {
                if (!bd.isAbstract()) {
                    throw new RuntimeException("Concrete bean should has class.");
                }
            } else {
                this.nameTypes.put(name, type);
            }
        }
    }

    public boolean isPrimary(String name) {
        return this.definitionRegistry.getBeanDefinition(name).isPrimary();
    }
}

