/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.inject.spring.config;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.beangle.commons.bean.Disposable;
import org.beangle.commons.bean.Initializing;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.event.EventListener;
import org.beangle.commons.inject.Resources;
import org.beangle.commons.inject.Scope;
import org.beangle.commons.inject.bind.BeanConfig;
import org.beangle.commons.inject.bind.BindModule;
import org.beangle.commons.inject.bind.BindRegistry;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.ClassLoaders;
import org.beangle.commons.lang.Strings;
import org.beangle.commons.lang.reflect.Reflections;
import org.beangle.commons.lang.time.Stopwatch;
import org.beangle.inject.spring.SpringEventMulticaster;
import org.beangle.inject.spring.config.BeanDefinitionReader;
import org.beangle.inject.spring.config.ReconfigBeanDefinitionHolder;
import org.beangle.inject.spring.config.ReconfigType;
import org.beangle.inject.spring.config.ResourcesEditor;
import org.beangle.inject.spring.config.SpringBindRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringConfigProcessor
implements BeanDefinitionRegistryPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SpringConfigProcessor.class);
    private Resources reconfigResources;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry definitionRegistry) throws BeansException {
        SpringBindRegistry registry = new SpringBindRegistry(definitionRegistry);
        Map<String, BeanDefinition> newDefinitions = this.registerModules(registry);
        this.registerBuildins(registry);
        this.reconfig(definitionRegistry, registry);
        this.lifecycle(registry, definitionRegistry);
        this.autowire(newDefinitions, registry);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        factory.registerCustomEditor(Resources.class, ResourcesEditor.class);
    }

    private void reconfig(BeanDefinitionRegistry registry, BindRegistry bindRegistry) {
        Stopwatch watch = new Stopwatch(true);
        if (null == this.reconfigResources || this.reconfigResources.isEmpty()) {
            return;
        }
        Set beanNames = CollectUtils.newHashSet();
        BeanDefinitionReader reader = new BeanDefinitionReader();
        for (URL url : this.reconfigResources.getAllPaths()) {
            List<ReconfigBeanDefinitionHolder> holders = reader.load((Resource)new UrlResource(url));
            for (ReconfigBeanDefinitionHolder holder : holders) {
                if (holder.getConfigType().equals((Object)ReconfigType.PRIMARY)) {
                    List names;
                    boolean finded;
                    Class clazz = ClassLoaders.loadClass((String)holder.getBeanDefinition().getBeanClassName());
                    if (clazz.isInterface() && (finded = (names = bindRegistry.getBeanNames(clazz)).contains(holder.getBeanName()))) {
                        for (String name : names) {
                            BeanDefinition bd = registry.getBeanDefinition(name);
                            bd.setPrimary(name.equals(holder.getBeanName()));
                        }
                    }
                    holder.setConfigType(ReconfigType.UPDATE);
                    holder.getBeanDefinition().setBeanClassName(null);
                }
                if (!holder.getConfigType().equals((Object)ReconfigType.UPDATE)) continue;
                if (registry.containsBeanDefinition(holder.getBeanName())) {
                    BeanDefinition definition = registry.getBeanDefinition(holder.getBeanName());
                    String successName = this.mergeDefinition(definition, holder);
                    if (null == successName) continue;
                    beanNames.add(successName);
                    continue;
                }
                logger.warn("No bean {} to reconfig defined in {}.", (Object)holder.getBeanName(), (Object)url);
            }
        }
        if (!beanNames.isEmpty()) {
            logger.info("Reconfig {} in {}", (Object)beanNames, (Object)watch);
        }
    }

    protected void lifecycle(BindRegistry registry, BeanDefinitionRegistry definitionRegistry) {
        for (String name : registry.getBeanNames()) {
            Class clazz = registry.getBeanType(name);
            String springName = name;
            if (springName.startsWith("&")) {
                springName = springName.substring(1);
            }
            if (!definitionRegistry.containsBeanDefinition(springName)) continue;
            AbstractBeanDefinition def = (AbstractBeanDefinition)definitionRegistry.getBeanDefinition(springName);
            if (Initializing.class.isAssignableFrom(clazz) && null == def.getInitMethodName() && !def.getPropertyValues().contains("init-method")) {
                def.setInitMethodName("init");
            }
            if (!Disposable.class.isAssignableFrom(clazz) || null != def.getDestroyMethodName() || def.getPropertyValues().contains("destroy-method")) continue;
            def.setDestroyMethodName("destroy");
        }
    }

    protected void registerBuildins(BindRegistry registry) {
        List listenerBeans = registry.getBeanNames(EventListener.class);
        BeanConfig.Definition eventMulticaster = new BeanConfig.Definition(SpringEventMulticaster.class.getName(), SpringEventMulticaster.class, Scope.SINGLETON.toString());
        eventMulticaster.property("listenerBeans", (Object)listenerBeans);
        this.registerBean(eventMulticaster, registry);
    }

    protected String mergeDefinition(BeanDefinition target, ReconfigBeanDefinitionHolder source) {
        if (null == target.getBeanClassName()) {
            logger.warn("ingore bean definition {} for without class", (Object)source.getBeanName());
            return null;
        }
        if (null != source.getBeanDefinition().getBeanClassName() && !source.getBeanDefinition().getBeanClassName().equals(target.getBeanClassName())) {
            target.setBeanClassName(source.getBeanDefinition().getBeanClassName());
            for (PropertyValue pv : target.getPropertyValues().getPropertyValues()) {
                target.getPropertyValues().removePropertyValue(pv);
            }
            target.getConstructorArgumentValues().clear();
        }
        MutablePropertyValues pvs = source.getBeanDefinition().getPropertyValues();
        for (PropertyValue pv : pvs.getPropertyValueList()) {
            String name = pv.getName();
            target.getPropertyValues().addPropertyValue(name, pv.getValue());
            logger.debug("config {}.{} = {}", new Object[]{source.getBeanName(), name, pv.getValue()});
        }
        logger.debug("Reconfig bean {} ", (Object)source.getBeanName());
        return source.getBeanName();
    }

    protected Map<String, BeanDefinition> registerModules(BindRegistry registry) {
        Stopwatch watch = new Stopwatch(true);
        List modules = registry.getBeanNames(BindModule.class);
        Map newBeanDefinitions = CollectUtils.newHashMap();
        for (String name : modules) {
            Class beanClass = registry.getBeanType(name);
            BeanConfig config = null;
            try {
                config = ((BindModule)beanClass.newInstance()).getConfig();
            }
            catch (Exception e) {
                logger.error("class initialization error of  " + beanClass, (Throwable)e);
                continue;
            }
            List definitions = config.getDefinitions();
            for (BeanConfig.Definition definition : definitions) {
                String beanName = definition.beanName;
                if (registry.contains(beanName)) {
                    logger.warn("Ingore exists bean definition {}", (Object)beanName);
                    continue;
                }
                BeanDefinition def = this.registerBean(definition, registry);
                newBeanDefinitions.put(beanName, def);
            }
        }
        logger.info("Auto register {} beans in {}", (Object)newBeanDefinitions.size(), (Object)watch);
        return newBeanDefinitions;
    }

    private BeanDefinition convert(BeanConfig.Definition definition) {
        GenericBeanDefinition def = new GenericBeanDefinition();
        def.setBeanClass(definition.clazz);
        def.setScope(definition.scope);
        if (null != definition.initMethod) {
            def.setInitMethodName(definition.initMethod);
        }
        if (null != definition.destroyMethod) {
            def.setDestroyMethodName(definition.destroyMethod);
        }
        MutablePropertyValues mpv = new MutablePropertyValues();
        for (Map.Entry entry : definition.getProperties().entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Collection) {
                if (value instanceof List) {
                    ManagedList list = new ManagedList();
                    for (Object e : (List)value) {
                        if (e instanceof BeanConfig.ReferenceValue) {
                            list.add(new RuntimeBeanReference(((BeanConfig.ReferenceValue)e).ref));
                            continue;
                        }
                        list.add(e);
                    }
                    value = list;
                }
                if (value instanceof Set) {
                    ManagedSet set = new ManagedSet();
                    for (Object e : (Set)value) {
                        if (e instanceof BeanConfig.ReferenceValue) {
                            set.add(new RuntimeBeanReference(((BeanConfig.ReferenceValue)e).ref));
                            continue;
                        }
                        set.add(e);
                    }
                    value = set;
                }
            } else if (value instanceof Properties) {
                ManagedProperties props = new ManagedProperties();
                Enumeration<?> propertyNames = ((Properties)value).propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String string = propertyNames.nextElement().toString();
                    props.put((Object)new TypedStringValue(string), (Object)new TypedStringValue(((Properties)value).getProperty(string)));
                }
                value = props;
            } else if (value instanceof Map) {
                ManagedMap maps = new ManagedMap();
                for (Map.Entry entry2 : ((Map)value).entrySet()) {
                    if (entry2.getValue() instanceof BeanConfig.ReferenceValue) {
                        maps.put(entry2.getKey(), new RuntimeBeanReference(((BeanConfig.ReferenceValue)entry2.getValue()).ref));
                        continue;
                    }
                    maps.put(entry2.getKey(), entry2.getValue());
                }
                value = maps;
            } else if (value instanceof BeanConfig.Definition) {
                value = new BeanDefinitionHolder(this.convert((BeanConfig.Definition)value), ((BeanConfig.Definition)value).beanName);
            } else if (value instanceof BeanConfig.ReferenceValue) {
                value = new RuntimeBeanReference(((BeanConfig.ReferenceValue)value).ref);
            }
            mpv.add((String)entry.getKey(), value);
        }
        def.setAutowireMode(0);
        def.setLazyInit(definition.lazyInit);
        def.setAbstract(definition.isAbstract());
        def.setParentName(definition.parent);
        def.setPrimary(definition.primary);
        if (null != definition.constructorArgs) {
            ConstructorArgumentValues cav = new ConstructorArgumentValues();
            for (Object arg : definition.constructorArgs) {
                cav.addGenericArgumentValue(arg);
            }
            def.setConstructorArgumentValues(cav);
        }
        def.setPropertyValues(mpv);
        return def;
    }

    protected BeanDefinition registerBean(BeanConfig.Definition def, BindRegistry registry) {
        BeanDefinition bd = this.convert(def);
        if (def.isAbstract() && def.clazz == null || FactoryBean.class.isAssignableFrom(def.clazz)) {
            try {
                Class target = def.targetClass;
                if (null == target && def.clazz != null) {
                    target = ((FactoryBean)def.clazz.newInstance()).getObjectType();
                }
                Assert.isTrue((null != target || def.isAbstract() ? 1 : 0) != 0, (String)"Concrete bean [%1$s] should has class.", (Object[])new Object[]{def.beanName});
                registry.register(target, def.beanName, new Object[]{bd});
                if (!def.isAbstract()) {
                    registry.register(def.clazz, "&" + def.beanName, new Object[0]);
                }
            }
            catch (Exception e) {
                logger.error("Cannot get Factory's Object Type {}", (Object)def.clazz);
            }
        } else {
            registry.register(def.clazz, def.beanName, new Object[]{bd});
        }
        logger.debug("Register definition {} for {}", (Object)def.beanName, (Object)def.clazz);
        return bd;
    }

    protected void autowire(Map<String, BeanDefinition> newBeanDefinitions, BindRegistry registry) {
        Stopwatch watch = new Stopwatch(true);
        for (Map.Entry<String, BeanDefinition> entry : newBeanDefinitions.entrySet()) {
            this.autowireBean(entry.getKey(), entry.getValue(), registry);
        }
        logger.info("Auto wire {} beans in {}", (Object)newBeanDefinitions.size(), (Object)watch);
    }

    protected void autowireBean(String beanName, BeanDefinition mbd, BindRegistry registry) {
        Map<String, Class<?>> properties = this.unsatisfiedNonSimpleProperties(mbd);
        for (Map.Entry<String, Class<?>> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            Class<?> propertyType = entry.getValue();
            List beanNames = registry.getBeanNames(propertyType);
            boolean binded = false;
            if (beanNames.size() == 1) {
                mbd.getPropertyValues().add(propertyName, (Object)new RuntimeBeanReference((String)beanNames.get(0)));
                binded = true;
            } else if (beanNames.size() > 1) {
                for (String name : beanNames) {
                    if (!registry.isPrimary(name)) continue;
                    mbd.getPropertyValues().add(propertyName, (Object)new RuntimeBeanReference(name));
                    binded = true;
                    break;
                }
                if (!binded) {
                    for (String name : beanNames) {
                        if (!name.equals(propertyName)) continue;
                        mbd.getPropertyValues().add(propertyName, (Object)new RuntimeBeanReference(name));
                        binded = true;
                        break;
                    }
                }
            }
            if (binded) continue;
            if (beanNames.isEmpty()) {
                logger.debug("{}'s {} cannot found candidate beans.", (Object)beanName, (Object)propertyName);
                continue;
            }
            logger.warn("{}'s {} expected single bean but found {} : {}", new Object[]{beanName, propertyName, beanNames.size(), beanNames});
        }
    }

    private Map<String, Class<?>> unsatisfiedNonSimpleProperties(BeanDefinition mbd) {
        Map properties = CollectUtils.newHashMap();
        if (mbd.isAbstract()) {
            return properties;
        }
        Class clazz = ClassLoaders.loadClass((String)((GenericBeanDefinition)mbd).getBeanClassName());
        MutablePropertyValues pvs = mbd.getPropertyValues();
        for (Method m : Reflections.getBeanSetters((Class)clazz)) {
            String propertyName = Strings.uncapitalize((String)m.getName().substring(3));
            Class<?> propertyType = m.getParameterTypes()[0];
            if (pvs.contains(propertyName) || propertyType.isArray() || propertyType.getName().startsWith("java.")) continue;
            properties.put(propertyName, propertyType);
        }
        return properties;
    }

    public void setReconfigResources(String reconfigResources) {
        ResourcesEditor re = new ResourcesEditor();
        re.setAsText(reconfigResources);
        this.reconfigResources = (Resources)re.getValue();
    }
}

