/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.inject.spring.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.beangle.inject.spring.web.ContextLoader;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.impl.ContainerUtil;
import org.directwebremoting.impl.DefaultContainer;
import org.directwebremoting.impl.StartupUtil;
import org.directwebremoting.servlet.UrlProcessor;
import org.directwebremoting.spring.SpringContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ConfigurableApplicationContext;

public class DwrSpringServlet
extends HttpServlet {
    private static final long serialVersionUID = 1843603170043922633L;
    static String DEFAULT_SPRING_CONFIGURATOR_ID = "__dwrConfiguration";
    private SpringContainer container;
    protected WebContextFactory.WebContextBuilder webContextBuilder;
    private boolean includeDefaultConfig = true;
    private List configurators = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(DwrSpringServlet.class);

    public void setConfigurators(List configurators) {
        this.configurators = configurators;
    }

    public void setIncludeDefaultConfig(boolean includeDefaultConfig) {
        this.includeDefaultConfig = includeDefaultConfig;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        try {
            ConfigurableApplicationContext webappContext = ContextLoader.getContext(servletContext);
            this.container = new SpringContainer();
            this.container.setBeanFactory((BeanFactory)webappContext);
            ContainerUtil.setupDefaults((DefaultContainer)this.container, (ServletConfig)servletConfig);
            ContainerUtil.setupFromServletConfig((DefaultContainer)this.container, (ServletConfig)servletConfig);
            this.container.setupFinished();
            this.webContextBuilder = StartupUtil.initWebContext((ServletConfig)servletConfig, (ServletContext)servletContext, (Container)this.container);
            StartupUtil.initServerContext((ServletConfig)servletConfig, (ServletContext)servletContext, (Container)this.container);
            ContainerUtil.prepareForWebContextFilter((ServletContext)servletContext, (ServletConfig)servletConfig, (Container)this.container, (WebContextFactory.WebContextBuilder)this.webContextBuilder, (HttpServlet)this);
            try {
                this.configurators.add(webappContext.getBean(DEFAULT_SPRING_CONFIGURATOR_ID));
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new ServletException("No DWR configuration was found in your application context, make sure to define one", (Throwable)ex);
            }
            if (this.includeDefaultConfig) {
                ContainerUtil.configureFromSystemDwrXml((Container)this.container);
            }
            ContainerUtil.configureFromInitParams((Container)this.container, (ServletConfig)servletConfig);
            ContainerUtil.configure((Container)this.container, (List)this.configurators);
            ContainerUtil.publishContainer((Container)this.container, (ServletConfig)servletConfig);
        }
        catch (InstantiationException ex) {
            throw new BeanCreationException("Failed to instansiate", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new BeanCreationException("Access error", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error("init failed", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        finally {
            this.webContextBuilder.unset();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.webContextBuilder.set(request, response, this.getServletConfig(), this.getServletContext(), (Container)this.container);
            UrlProcessor processor = (UrlProcessor)this.container.getBean(UrlProcessor.class.getName());
            processor.handle(request, response);
        }
        finally {
            this.webContextBuilder.unset();
        }
    }
}

