/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.inject.spring.web;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.web.util.RequestUtils;
import org.springframework.core.io.AbstractFileResolvingResource;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class ServletContextResource
extends AbstractFileResolvingResource
implements ContextResource {
    private final ServletContext servletContext;
    private final String path;

    public ServletContextResource(ServletContext servletContext, String path) {
        Assert.notNull((Object)servletContext, (String)"Cannot resolve ServletContextResource without ServletContext", (Object[])new Object[0]);
        this.servletContext = servletContext;
        Assert.notNull((Object)path, (String)"Path is required", (Object[])new Object[0]);
        String pathToUse = StringUtils.cleanPath((String)path);
        if (!pathToUse.startsWith("/")) {
            pathToUse = "/" + pathToUse;
        }
        this.path = pathToUse;
    }

    public final ServletContext getServletContext() {
        return this.servletContext;
    }

    public final String getPath() {
        return this.path;
    }

    public boolean exists() {
        try {
            URL url = this.servletContext.getResource(this.path);
            return url != null;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = this.servletContext.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException("Could not open " + this.getDescription());
        }
        return is;
    }

    public URL getURL() throws IOException {
        URL url = this.servletContext.getResource(this.path);
        if (url == null) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    public File getFile() throws IOException {
        String realPath = RequestUtils.getRealPath((ServletContext)this.servletContext, (String)this.path);
        return new File(realPath);
    }

    public Resource createRelative(String relativePath) {
        String pathToUse = StringUtils.applyRelativePath((String)this.path, (String)relativePath);
        return new ServletContextResource(this.servletContext, pathToUse);
    }

    public String getFilename() {
        return StringUtils.getFilename((String)this.path);
    }

    public String getDescription() {
        return "ServletContext resource [" + this.path + "]";
    }

    public String getPathWithinContext() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ServletContextResource) {
            ServletContextResource otherRes = (ServletContextResource)((Object)obj);
            return this.servletContext.equals(otherRes.servletContext) && this.path.equals(otherRes.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

