/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.collection.page.Page;
import org.beangle.commons.collection.page.PageLimit;
import org.beangle.commons.collection.page.SinglePage;
import org.beangle.commons.dao.EntityDao;
import org.beangle.commons.dao.Operation;
import org.beangle.commons.dao.query.Lang;
import org.beangle.commons.dao.query.LimitQuery;
import org.beangle.commons.dao.query.Query;
import org.beangle.commons.dao.query.QueryBuilder;
import org.beangle.commons.dao.query.builder.Condition;
import org.beangle.commons.dao.query.builder.OqlBuilder;
import org.beangle.commons.entity.Entity;
import org.beangle.commons.entity.metadata.ModelMeta;
import org.beangle.commons.lang.Arrays;
import org.beangle.commons.lang.Assert;
import org.beangle.commons.lang.Strings;
import org.beangle.orm.hibernate.internal.SessionHolder;
import org.beangle.orm.hibernate.internal.SessionUtils;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.StreamUtils;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateEntityDao
implements EntityDao {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected SessionFactory sessionFactory;
    protected ModelMeta modelMeta;

    protected Session getSession() {
        SessionHolder holder = SessionUtils.currentSession(this.sessionFactory);
        return null != holder ? holder.getSession() : null;
    }

    public <T extends Entity<ID>, ID extends Serializable> T get(Class<T> clazz, ID id) {
        return (T)((Entity)this.get(this.modelMeta.getEntityType(clazz).getEntityName(), id));
    }

    public <T> T get(String entityName, Serializable id) {
        if (Strings.contains((CharSequence)entityName, (int)46)) {
            return (T)this.getSession().get(entityName, id);
        }
        String hql = "from " + entityName + " where id =:id";
        org.hibernate.Query query = this.getSession().createQuery(hql);
        query.setParameter("id", (Object)id);
        List rs = query.list();
        if (rs.isEmpty()) {
            return null;
        }
        return (T)rs.get(0);
    }

    public <T extends Entity<?>> List<T> getAll(Class<T> clazz) {
        String hql = "from " + this.modelMeta.getEntityType(clazz).getEntityName();
        org.hibernate.Query query = this.getSession().createQuery(hql);
        query.setCacheable(true);
        return query.list();
    }

    public <T extends Entity<ID>, ID extends Serializable> List<T> get(Class<T> clazz, ID[] values) {
        return this.get(clazz, "id", (Object[])values);
    }

    public <T extends Entity<ID>, ID extends Serializable> List<T> get(Class<T> clazz, Collection<ID> values) {
        return this.get(clazz, "id", values.toArray());
    }

    public <T extends Entity<?>> List<T> get(Class<T> entityClass, String keyName, Object ... values) {
        if (entityClass == null || Strings.isEmpty((CharSequence)keyName) || values == null || values.length == 0) {
            return Collections.emptyList();
        }
        String entityName = this.modelMeta.getEntityType(entityClass).getEntityName();
        return this.get(entityName, keyName, values);
    }

    public <T extends Entity<?>> List<T> get(Class<T> clazz, String keyName, Collection<?> values) {
        if (clazz == null || Strings.isEmpty((CharSequence)keyName) || values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        String entityName = this.modelMeta.getEntityType(clazz).getEntityName();
        return this.get(entityName, keyName, values.toArray());
    }

    public <T> List<T> get(String entityName, String keyName, Object ... values) {
        StringBuilder hql = new StringBuilder();
        hql.append("select entity from ").append(entityName).append(" as entity where entity.").append(keyName).append(" in (:keyName)");
        Map parameterMap = CollectUtils.newHashMap();
        if (values.length < 500) {
            parameterMap.put("keyName", values);
            OqlBuilder query = OqlBuilder.hql((String)hql.toString());
            return this.search(query.params(parameterMap).build());
        }
        OqlBuilder query = OqlBuilder.hql((String)hql.toString());
        List rs = CollectUtils.newArrayList();
        for (int i = 0; i < values.length; i += 500) {
            int end = i + 500;
            if (end > values.length) {
                end = values.length;
            }
            parameterMap.put("keyName", Arrays.subarray((Object[])values, (int)i, (int)end));
            rs.addAll(this.search(query.params(parameterMap).build()));
        }
        return rs;
    }

    public <T extends Entity<?>> List<T> get(Class<T> clazz, String[] attrs, Object ... values) {
        Map params = CollectUtils.newHashMap();
        for (int i = 0; i < attrs.length; ++i) {
            params.put(attrs[i], values[i]);
        }
        return this.get(clazz, params);
    }

    public <T extends Entity<?>> List<T> get(Class<T> clazz, Map<String, Object> parameterMap) {
        if (clazz == null || parameterMap == null || parameterMap.isEmpty()) {
            return Collections.emptyList();
        }
        String entityName = clazz.getName();
        StringBuilder hql = new StringBuilder();
        hql.append("select entity from ").append(entityName).append(" as entity ").append(" where ");
        HashMap<String, Object> m = new HashMap<String, Object>(parameterMap.keySet().size());
        int i = 0;
        for (String keyName : parameterMap.keySet()) {
            if (Strings.isEmpty((CharSequence)keyName)) {
                return null;
            }
            Object keyValue = parameterMap.get(keyName);
            String[] tempName = Strings.split((String)keyName, (String)"\\.");
            String name = tempName[tempName.length - 1] + ++i;
            m.put(name, keyValue);
            if (keyValue != null && (keyValue.getClass().isArray() || keyValue instanceof Collection)) {
                hql.append("entity.").append(keyName).append(" in (:").append(name).append(") and ");
                continue;
            }
            hql.append("entity.").append(keyName).append(" = :").append(name).append(" and ");
        }
        if (i > 0) {
            hql.delete(hql.length() - " and ".length(), hql.length());
        }
        return this.search(hql.toString(), m);
    }

    public <T> List<T> search(Query<T> query) {
        if (query instanceof LimitQuery) {
            LimitQuery limitQuery = (LimitQuery)query;
            if (null == limitQuery.getLimit()) {
                return QuerySupport.find(limitQuery, this.getSession());
            }
            return new SinglePage(limitQuery.getLimit().getPageNo(), limitQuery.getLimit().getPageSize(), QuerySupport.count(limitQuery, this.getSession()), QuerySupport.find(query, this.getSession()));
        }
        return QuerySupport.find(query, this.getSession());
    }

    public <T> List<T> search(QueryBuilder<T> builder) {
        return this.search(builder.build());
    }

    public <T> T uniqueResult(QueryBuilder<T> builder) {
        List<T> list = this.search(builder.build());
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        throw new RuntimeException("not unique query" + builder);
    }

    public <T> List<T> search(String query, Object ... params) {
        return QuerySupport.setParameter(this.getNamedOrCreateQuery(query), params).list();
    }

    public <T> List<T> search(String queryString, Map<String, Object> params) {
        return QuerySupport.setParameter(this.getNamedOrCreateQuery(queryString), params).list();
    }

    public <T> List<T> search(String queryString, Map<String, Object> params, PageLimit limit, boolean cacheable) {
        org.hibernate.Query query = this.getNamedOrCreateQuery(queryString);
        query.setCacheable(cacheable);
        if (null == limit) {
            return QuerySupport.setParameter(query, params).list();
        }
        return this.paginateQuery(query, params, limit);
    }

    private org.hibernate.Query getNamedOrCreateQuery(String queryString) {
        if (queryString.charAt(0) == '@') {
            return this.getSession().getNamedQuery(queryString.substring(1));
        }
        return this.getSession().createQuery(queryString);
    }

    public void evict(Object entity) {
        this.getSession().evict(entity);
    }

    public int executeUpdate(String queryString, Object ... argument) {
        return QuerySupport.setParameter(this.getNamedOrCreateQuery(queryString), argument).executeUpdate();
    }

    public int[] executeUpdateRepeatly(String queryString, Collection<Object[]> arguments) {
        org.hibernate.Query query = this.getNamedOrCreateQuery(queryString);
        int[] updates = new int[arguments.size()];
        int i = 0;
        for (Object[] params : arguments) {
            updates[i] = QuerySupport.setParameter(query, params).executeUpdate();
            ++i;
        }
        return updates;
    }

    public int executeUpdate(String queryString, Map<String, Object> parameterMap) {
        return QuerySupport.setParameter(this.getNamedOrCreateQuery(queryString), parameterMap).executeUpdate();
    }

    public Blob createBlob(InputStream inputStream, int length) {
        return Hibernate.getLobCreator((Session)this.getSession()).createBlob(inputStream, (long)length);
    }

    public Blob createBlob(InputStream inputStream) {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(inputStream.available());
            StreamUtils.copy((InputStream)inputStream, (OutputStream)buffer);
            return Hibernate.getLobCreator((Session)this.getSession()).createBlob(buffer.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Clob createClob(String str) {
        return Hibernate.getLobCreator((Session)this.getSession()).createClob(str);
    }

    public void refresh(Object entity) {
        this.getSession().refresh(entity);
    }

    public <T> T initialize(T proxy) {
        if (proxy instanceof HibernateProxy) {
            LazyInitializer init = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            if (null == init.getSession() || init.getSession().isClosed()) {
                proxy = this.getSession().get(init.getEntityName(), init.getIdentifier());
            } else {
                Hibernate.initialize(proxy);
            }
        } else if (proxy instanceof PersistentCollection) {
            Hibernate.initialize(proxy);
        }
        return proxy;
    }

    private <T> Page<T> paginateQuery(org.hibernate.Query query, Map<String, Object> params, PageLimit limit) {
        QuerySupport.setParameter(query, params);
        query.setFirstResult((limit.getPageNo() - 1) * limit.getPageSize()).setMaxResults(limit.getPageSize());
        List targetList = query.list();
        String queryStr = this.buildCountQueryStr(query);
        Object countQuery = null;
        countQuery = query instanceof SQLQuery ? this.getSession().createSQLQuery(queryStr) : this.getSession().createQuery(queryStr);
        QuerySupport.setParameter((org.hibernate.Query)countQuery, params);
        return new SinglePage(limit.getPageNo(), limit.getPageSize(), ((Number)countQuery.uniqueResult()).intValue(), targetList);
    }

    public void saveOrUpdate(Object ... entities) {
        if (null == entities) {
            return;
        }
        for (Object entity : entities) {
            if (entity instanceof Collection) {
                for (Object elementEntry : (Collection)entity) {
                    this.persistEntity(elementEntry, null);
                }
                continue;
            }
            this.persistEntity(entity, null);
        }
    }

    public void save(Object ... entities) {
        if (null == entities) {
            return;
        }
        for (Object entity : entities) {
            if (entity instanceof Collection) {
                for (Object elementEntry : (Collection)entity) {
                    this.saveEntity(elementEntry, null);
                }
                continue;
            }
            this.saveEntity(entity, null);
        }
    }

    public void execute(Operation ... opts) {
        block4: for (Operation operation : opts) {
            switch (operation.type) {
                case SAVE_UPDATE: {
                    this.persistEntity(operation.data, null);
                    continue block4;
                }
                case REMOVE: {
                    this.remove(operation.data);
                }
            }
        }
    }

    public void execute(Operation.Builder builder) {
        for (Operation operation : builder.build()) {
            switch (operation.type) {
                case SAVE_UPDATE: {
                    this.persistEntity(operation.data, null);
                    break;
                }
                case REMOVE: {
                    this.remove(operation.data);
                }
            }
        }
    }

    public void saveOrUpdate(Collection<?> entities) {
        if (null != entities && !entities.isEmpty()) {
            for (Object entity : entities) {
                this.persistEntity(entity, null);
            }
        }
    }

    private void saveEntity(Object entity, String entityName) {
        if (null == entity) {
            return;
        }
        if (null != entityName) {
            this.getSession().save(entityName, entity);
        } else if (entity instanceof HibernateProxy) {
            this.getSession().save(entity);
        } else {
            this.getSession().save(this.modelMeta.getEntityType(entity.getClass()).getEntityName(), entity);
        }
    }

    private void persistEntity(Object entity, String entityName) {
        if (null == entity) {
            return;
        }
        if (null != entityName) {
            this.getSession().saveOrUpdate(entityName, entity);
        } else if (entity instanceof HibernateProxy) {
            this.getSession().saveOrUpdate(entity);
        } else {
            this.getSession().saveOrUpdate(this.modelMeta.getEntityType(entity.getClass()).getEntityName(), entity);
        }
    }

    public void saveOrUpdate(String entityName, Collection<?> entities) {
        if (null != entities && !entities.isEmpty()) {
            for (Object entity : entities) {
                this.persistEntity(entity, entityName);
            }
        }
    }

    public void saveOrUpdate(String entityName, Object ... entities) {
        if (null == entities) {
            return;
        }
        for (Object entity : entities) {
            this.persistEntity(entity, entityName);
        }
    }

    public int update(Class<?> entityClass, String attr, Object[] values, String[] argumentName, Object[] argumentValue) {
        if (null == values || values.length == 0) {
            return 0;
        }
        Map updateParams = CollectUtils.newHashMap();
        for (int i = 0; i < argumentValue.length; ++i) {
            updateParams.put(argumentName[i], argumentValue[i]);
        }
        return this.update(entityClass, attr, values, updateParams);
    }

    public int update(Class<?> entityClass, String attr, Object[] values, Map<String, Object> updateParams) {
        if (null == values || values.length == 0 || updateParams.isEmpty()) {
            return 0;
        }
        String entityName = entityClass.getName();
        StringBuilder hql = new StringBuilder();
        hql.append("update ").append(entityName).append(" set ");
        Map newParams = CollectUtils.newHashMap();
        for (String parameterName : updateParams.keySet()) {
            if (null == parameterName) continue;
            String locateParamName = Strings.replace((String)parameterName, (String)".", (String)"_");
            hql.append(parameterName).append(" = ").append(":").append(locateParamName).append(",");
            newParams.put(locateParamName, updateParams.get(locateParamName));
        }
        hql.deleteCharAt(hql.length() - 1);
        hql.append(" where ").append(attr).append(" in (:ids)");
        newParams.put("ids", values);
        return this.executeUpdate(hql.toString(), newParams);
    }

    public void remove(Collection<?> entities) {
        if (null == entities || entities.isEmpty()) {
            return;
        }
        for (Object entity : entities) {
            if (null == entity) continue;
            this.getSession().delete(entity);
        }
    }

    public void remove(Object ... entities) {
        for (Object entity : entities) {
            if (null == entity) continue;
            if (entity instanceof Collection) {
                for (Object innerEntity : (Collection)entity) {
                    this.getSession().delete(innerEntity);
                }
                continue;
            }
            this.getSession().delete(entity);
        }
    }

    public boolean remove(Class<?> clazz, String attr, Object ... values) {
        if (clazz == null || Strings.isEmpty((CharSequence)attr) || values == null || values.length == 0) {
            return false;
        }
        String entityName = this.modelMeta.getEntityType(clazz).getEntityName();
        StringBuilder hql = new StringBuilder();
        hql.append("delete from ").append(entityName).append(" where ").append(attr).append(" in (:ids)");
        Map parameterMap = CollectUtils.newHashMap();
        parameterMap.put("ids", values);
        return this.executeUpdate(hql.toString(), parameterMap) > 0;
    }

    public boolean remove(Class<?> entityClass, String attr, Collection<?> values) {
        return this.remove(entityClass, attr, values.toArray());
    }

    public boolean remove(Class<?> clazz, Map<String, Object> keyMap) {
        if (clazz == null || keyMap == null || keyMap.isEmpty()) {
            return false;
        }
        String entityName = this.modelMeta.getEntityType(clazz).getEntityName();
        StringBuilder hql = new StringBuilder();
        hql.append("delete from ").append(entityName).append(" where ");
        Set<String> keySet = keyMap.keySet();
        Map params = CollectUtils.newHashMap();
        for (String keyName : keySet) {
            Object keyValue = keyMap.get(keyName);
            String paramName = keyName.replace('.', '_');
            params.put(paramName, keyValue);
            if (keyValue.getClass().isArray() || keyValue instanceof Collection) {
                hql.append(keyName).append(" in (:").append(paramName).append(") and ");
                continue;
            }
            hql.append(keyName).append(" = :").append(paramName).append(" and ");
        }
        hql.append(" (1=1) ");
        return this.executeUpdate(hql.toString(), params) > 0;
    }

    public long count(String entityName, String keyName, Object value) {
        String hql = "select count(*) from " + entityName + " where " + keyName + "=:value";
        Map params = CollectUtils.newHashMap();
        params.put("value", value);
        List rs = this.search(hql, params);
        if (rs.isEmpty()) {
            return 0L;
        }
        return ((Number)rs.get(0)).longValue();
    }

    public long count(Class<?> entityClass, String keyName, Object value) {
        return this.count(entityClass.getName(), keyName, value);
    }

    public long count(Class<?> entityClass, String[] attrs, Object[] values, String countAttr) {
        Assert.isTrue((null != attrs && null != values && attrs.length == values.length ? 1 : 0) != 0);
        String entityName = entityClass.getName();
        StringBuilder hql = new StringBuilder();
        if (Strings.isNotEmpty((CharSequence)countAttr)) {
            hql.append("select count(distinct ").append(countAttr).append(") from ");
        } else {
            hql.append("select count(*) from ");
        }
        hql.append(entityName).append(" as entity where ");
        Map params = CollectUtils.newHashMap();
        for (int i = 0; i < attrs.length; ++i) {
            if (Strings.isEmpty((CharSequence)attrs[i])) continue;
            String keyName = Strings.replace((String)attrs[i], (String)".", (String)"_");
            Object keyValue = values[i];
            params.put(keyName, keyValue);
            if (keyValue != null && (keyValue.getClass().isArray() || keyValue instanceof Collection)) {
                hql.append("entity.").append(attrs[i]).append(" in (:").append(keyName).append(')');
            } else {
                hql.append("entity.").append(attrs[i]).append(" = :").append(keyName);
            }
            if (i >= attrs.length - 1) continue;
            hql.append(" and ");
        }
        return ((Number)this.search(hql.toString(), params).get(0)).longValue();
    }

    public boolean exist(Class<?> entityClass, String attr, Object value) {
        return this.count(entityClass, attr, value) > 0L;
    }

    public boolean exist(String entityName, String attr, Object value) {
        return this.count(entityName, attr, value) > 0L;
    }

    public boolean exist(Class<?> entity, String[] attrs, Object[] values) {
        return this.count(entity, attrs, values, null) > 0L;
    }

    public boolean duplicate(Class<? extends Entity<?>> clazz, Serializable id, String codeName, Object codeValue) {
        List<Entity<?>> list;
        if (null != codeValue && Strings.isNotEmpty((CharSequence)codeValue.toString()) && (list = this.get(clazz, codeName, codeValue)) != null && !list.isEmpty()) {
            if (id == null) {
                return true;
            }
            for (Entity<?> info : list) {
                if (info.getId().equals(id)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean duplicate(String entityName, Serializable id, Map<String, Object> params) {
        StringBuilder b = new StringBuilder("from ");
        b.append(entityName).append(" where (1=1)");
        Map paramsMap = CollectUtils.newHashMap();
        int i = 0;
        for (String key : params.keySet()) {
            b.append(" and ").append(key).append('=').append(":param" + i);
            paramsMap.put("param" + i, params.get(key));
            ++i;
        }
        List list = this.search(b.toString(), paramsMap);
        if (!list.isEmpty()) {
            if (null == id) {
                return false;
            }
            for (Entity one : list) {
                if (one.getId().equals(id)) continue;
                return false;
            }
        }
        return true;
    }

    private String buildCountQueryStr(org.hibernate.Query query) {
        String queryStr = "select count(*) ";
        if (query instanceof SQLQuery) {
            queryStr = queryStr + "from (" + query.getQueryString() + ")";
        } else {
            String lowerCaseQueryStr = query.getQueryString().toLowerCase();
            String selectWhich = lowerCaseQueryStr.substring(0, query.getQueryString().indexOf("from"));
            int indexOfDistinct = selectWhich.indexOf("distinct");
            int indexOfFrom = lowerCaseQueryStr.indexOf("from");
            if (-1 != indexOfDistinct) {
                queryStr = Strings.contains((CharSequence)selectWhich, (CharSequence)",") ? "select count(" + query.getQueryString().substring(indexOfDistinct, query.getQueryString().indexOf(",")) + ")" : "select count(" + query.getQueryString().substring(indexOfDistinct, indexOfFrom) + ")";
            }
            queryStr = queryStr + query.getQueryString().substring(indexOfFrom);
        }
        return queryStr;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setModelMeta(ModelMeta modelMeta) {
        this.modelMeta = modelMeta;
    }

    public static final class QuerySupport {
        private QuerySupport() {
        }

        private static org.hibernate.Query buildHibernateQuery(Query<?> bquery, Session session) {
            Object hibernateQuery = null;
            hibernateQuery = bquery.getLang().equals((Object)Lang.HQL) ? session.createQuery(bquery.getStatement()) : session.createSQLQuery(bquery.getStatement());
            if (bquery.isCacheable()) {
                hibernateQuery.setCacheable(bquery.isCacheable());
            }
            QuerySupport.setParameter(hibernateQuery, bquery.getParams());
            return hibernateQuery;
        }

        public static int count(LimitQuery<?> limitQuery, Session hibernateSession) {
            Query cntQuery = limitQuery.getCountQuery();
            if (null == cntQuery) {
                org.hibernate.Query hibernateQuery = QuerySupport.buildHibernateQuery(limitQuery, hibernateSession);
                return hibernateQuery.list().size();
            }
            org.hibernate.Query hibernateQuery = QuerySupport.buildHibernateQuery(cntQuery, hibernateSession);
            Number count = (Number)hibernateQuery.uniqueResult();
            if (null == count) {
                return 0;
            }
            return count.intValue();
        }

        public static <T> List<T> find(Query<T> query, Session session) {
            if (query instanceof LimitQuery) {
                LimitQuery limitQuery = (LimitQuery)query;
                org.hibernate.Query hibernateQuery = QuerySupport.buildHibernateQuery(limitQuery, session);
                if (null == limitQuery.getLimit()) {
                    return hibernateQuery.list();
                }
                PageLimit limit = limitQuery.getLimit();
                hibernateQuery.setFirstResult((limit.getPageNo() - 1) * limit.getPageSize()).setMaxResults(limit.getPageSize());
                return hibernateQuery.list();
            }
            return QuerySupport.buildHibernateQuery(query, session).list();
        }

        public static org.hibernate.Query setParameter(org.hibernate.Query query, Object[] argument) {
            if (argument != null && argument.length > 0) {
                for (int i = 0; i < argument.length; ++i) {
                    query.setParameter(String.valueOf(i + 1), argument[i]);
                }
            }
            return query;
        }

        public static org.hibernate.Query setParameter(org.hibernate.Query query, Map<String, Object> parameterMap) {
            if (parameterMap != null && !parameterMap.isEmpty()) {
                for (String parameterName : parameterMap.keySet()) {
                    if (null == parameterName) break;
                    Object parameterValue = parameterMap.get(parameterName);
                    if (null == parameterValue) {
                        query.setParameter(parameterName, null);
                        continue;
                    }
                    if (parameterValue.getClass().isArray()) {
                        query.setParameterList(parameterName, (Object[])parameterValue);
                        continue;
                    }
                    if (parameterValue instanceof Collection) {
                        query.setParameterList(parameterName, (Collection)parameterValue);
                        continue;
                    }
                    query.setParameter(parameterName, parameterValue);
                }
            }
            return query;
        }

        public static void bindValues(org.hibernate.Query query, List<Condition> conditions) {
            int position = 0;
            boolean hasInterrogation = false;
            for (Condition condition : conditions) {
                if (Strings.contains((CharSequence)condition.getContent(), (CharSequence)"?")) {
                    hasInterrogation = true;
                }
                if (hasInterrogation) {
                    Iterator iterator = condition.getParams().iterator();
                    while (iterator.hasNext()) {
                        query.setParameter(position++, iterator.next());
                    }
                    continue;
                }
                List paramNames = condition.getParamNames();
                for (int i = 0; i < paramNames.size(); ++i) {
                    String name = (String)paramNames.get(i);
                    Object value = condition.getParams().get(i);
                    if (value.getClass().isArray()) {
                        query.setParameterList(name, (Object[])value);
                        continue;
                    }
                    if (value instanceof Collection) {
                        query.setParameterList(name, (Collection)value);
                        continue;
                    }
                    query.setParameter(name, value);
                }
            }
        }
    }
}

