/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.id;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import org.beangle.orm.hibernate.id.IdFunctor;
import org.beangle.orm.hibernate.id.TableSeqGenerator;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;

public class AutoIncrementGenerator
implements IdentifierGenerator,
Configurable {
    IdFunctor functor = null;

    public void configure(Type t, Properties params, Dialect dialect) throws MappingException {
        String entityName = params.getProperty("entity_name");
        String schema = null;
        if (null != entityName && null != TableSeqGenerator.namingStrategy) {
            schema = TableSeqGenerator.namingStrategy.getSchema(entityName);
        }
        String tableName = Table.qualify((String)dialect.quote(params.getProperty("catalog")), (String)dialect.quote(schema), (String)dialect.quote(params.getProperty("target_table")));
        this.functor = new IdFunctor(tableName, t instanceof LongType);
    }

    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        try {
            return this.functor.generate(session, object);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new HibernateException(e.getMessage());
        }
    }
}

