/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.beangle.commons.collection.CollectUtils;
import org.beangle.commons.lang.ClassLoaders;
import org.beangle.orm.hibernate.RailsNamingStrategy;
import org.beangle.orm.hibernate.TableNamingStrategy;
import org.beangle.orm.hibernate.id.AutoIncrementGenerator;
import org.beangle.orm.hibernate.id.TableSeqGenerator;
import org.beangle.orm.hibernate.internal.PersistentClassMerger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.hibernate.DuplicateMappingException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.SettingsFactory;
import org.hibernate.internal.util.xml.ErrorLogger;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class OverrideConfiguration
extends Configuration {
    private static Logger logger = LoggerFactory.getLogger(OverrideConfiguration.class);
    private int dynaupdateMinColumn = 7;

    public OverrideConfiguration() {
    }

    public OverrideConfiguration(SettingsFactory settingsFactory) {
        super(settingsFactory);
    }

    protected Configuration doConfigure(InputStream stream, String resourceName) throws HibernateException {
        try {
            ErrorLogger errorLogger = new ErrorLogger(resourceName);
            SAXReader reader = this.xmlHelper.createSAXReader((ErrorHandler)errorLogger, this.getEntityResolver());
            reader.setValidation(false);
            Document document = reader.read(new InputSource(stream));
            if (errorLogger.hasErrors()) {
                throw new MappingException("invalid configuration", (Throwable)errorLogger.getErrors().get(0));
            }
            this.doConfigure(document);
        }
        catch (DocumentException e) {
            throw new HibernateException("Could not parse configuration: " + resourceName, (Throwable)e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {
                logger.error("Could not close input stream for {}", (Object)resourceName);
            }
        }
        return this;
    }

    public Mappings createMappings() {
        return new OverrideMappings();
    }

    private void configSchema() {
        TableNamingStrategy namingStrategy = null;
        if (this.getNamingStrategy() instanceof RailsNamingStrategy) {
            namingStrategy = ((RailsNamingStrategy)this.getNamingStrategy()).getTableNamingStrategy();
        }
        if (null == namingStrategy) {
            return;
        }
        TableSeqGenerator.namingStrategy = namingStrategy;
        if (namingStrategy.isMultiSchema()) {
            for (PersistentClass clazz : this.classes.values()) {
                String schema = namingStrategy.getSchema(clazz.getEntityName());
                if (null == schema) continue;
                clazz.getTable().setSchema(schema);
            }
            for (Collection collection : this.collections.values()) {
                String schema;
                Table table = collection.getCollectionTable();
                if (null == table || null == (schema = namingStrategy.getSchema(collection.getOwnerEntityName()))) continue;
                table.setSchema(schema);
            }
        }
    }

    protected void secondPassCompile() throws MappingException {
        super.secondPassCompile();
        this.configSchema();
        Set hackedEntityNames = CollectUtils.newHashSet();
        for (Map.Entry entry : this.classes.entrySet()) {
            if (((String)entry.getKey()).equals(((PersistentClass)entry.getValue()).getEntityName())) continue;
            hackedEntityNames.add(entry.getKey());
        }
        for (String entityName : hackedEntityNames) {
            this.classes.remove(entityName);
        }
    }

    public int getDynaupdateMinColumn() {
        return this.dynaupdateMinColumn;
    }

    public void setDynaupdateMinColumn(int dynaupdateMinColumn) {
        this.dynaupdateMinColumn = dynaupdateMinColumn;
    }

    protected class OverrideMappings
    extends Configuration.MappingsImpl {
        private final Map<String, List<Collection>> tmpColls;

        public OverrideMappings() {
            super((Configuration)OverrideConfiguration.this);
            this.tmpColls = CollectUtils.newHashMap();
            IdGenerator tableSeqGen = new IdGenerator();
            tableSeqGen.setName("table_sequence");
            tableSeqGen.setIdentifierGeneratorStrategy(TableSeqGenerator.class.getName());
            this.addDefaultGenerator(tableSeqGen);
            IdGenerator idGen = new IdGenerator();
            idGen.setName("auto_increment");
            idGen.setIdentifierGeneratorStrategy(AutoIncrementGenerator.class.getName());
            this.addDefaultGenerator(idGen);
        }

        public void addClass(PersistentClass pClass) throws DuplicateMappingException {
            List<Collection> cols;
            PersistentClass old;
            if (!pClass.useDynamicUpdate() && pClass.getTable().getColumnSpan() >= OverrideConfiguration.this.dynaupdateMinColumn) {
                pClass.setDynamicUpdate(true);
            }
            String className = pClass.getClassName();
            String entityName = pClass.getEntityName();
            boolean entityNameChanged = false;
            String jpaEntityName = pClass.getJpaEntityName();
            if (null != jpaEntityName && jpaEntityName.contains(".")) {
                entityName = jpaEntityName;
                pClass.setEntityName(entityName);
                entityNameChanged = true;
            }
            if ((old = (PersistentClass)OverrideConfiguration.this.classes.get(entityName)) == null) {
                OverrideConfiguration.this.classes.put(entityName, pClass);
            } else if (old.getMappedClass().isAssignableFrom(pClass.getMappedClass())) {
                PersistentClassMerger.merge(pClass, old);
            }
            if (entityNameChanged) {
                OverrideConfiguration.this.classes.put(className, pClass);
            }
            if (null == (cols = this.tmpColls.remove(entityName))) {
                cols = this.tmpColls.remove(className);
            }
            if (null != cols) {
                for (Collection col : cols) {
                    String colName = null;
                    colName = col.getRole().startsWith(className) ? col.getRole().substring(className.length() + 1) : col.getRole().substring(entityName.length() + 1);
                    col.setRole(entityName + "." + colName);
                    OverrideConfiguration.this.collections.put(col.getRole(), col);
                }
            }
        }

        public void addImport(String entityName, String rename) throws DuplicateMappingException {
            String existing = (String)OverrideConfiguration.this.imports.get(rename);
            if (null == existing) {
                OverrideConfiguration.this.imports.put(rename, entityName);
            } else if (ClassLoaders.loadClass((String)existing).isAssignableFrom(ClassLoaders.loadClass((String)entityName))) {
                OverrideConfiguration.this.imports.put(rename, entityName);
            } else {
                throw new DuplicateMappingException("duplicate import: " + rename + " refers to both " + entityName + " and " + existing + " (try using auto-import=\"false\")", "import", rename);
            }
        }

        public void addCollection(Collection collection) throws DuplicateMappingException {
            String entityName = collection.getOwnerEntityName();
            List cols = this.tmpColls.get(entityName);
            if (null == cols) {
                cols = CollectUtils.newArrayList();
                this.tmpColls.put(entityName, cols);
            }
            cols.add(collection);
        }
    }
}

