/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.orm.hibernate.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.beangle.commons.inject.Container;
import org.beangle.commons.inject.ContainerHook;
import org.beangle.commons.inject.Containers;
import org.beangle.commons.web.filter.OncePerRequestFilter;
import org.beangle.orm.hibernate.internal.SessionUtils;
import org.hibernate.SessionFactory;

public class OpenSessionInViewFilter
extends OncePerRequestFilter
implements ContainerHook {
    public static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    private String sessionFactoryBeanName = "sessionFactory";
    private SessionFactory sessionFactory;

    public void setSessionFactoryBeanName(String sessionFactoryBeanName) {
        this.sessionFactoryBeanName = sessionFactoryBeanName;
    }

    protected void initFilterBean() throws ServletException {
        super.initFilterBean();
        Container context = Containers.getRoot();
        if (null != context) {
            this.setSessionFactory((SessionFactory)context.getBean((Object)this.sessionFactoryBeanName).get());
        } else {
            Containers.getHooks().add(this);
        }
    }

    public void notify(Container context) {
        this.setSessionFactory((SessionFactory)context.getBean(SessionFactory.class).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.firstEnter(request)) {
            SessionUtils.enableBinding(this.sessionFactory);
            try {
                chain.doFilter(request, response);
            }
            finally {
                SessionUtils.disableBinding(this.sessionFactory);
                SessionUtils.closeSession(this.sessionFactory);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

