/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.lib.archive.AbstractApplicationArchiveEntry;
import org.cloudfoundry.client.lib.archive.ApplicationArchive;
import org.springframework.util.Assert;

public class DirectoryApplicationArchive
implements ApplicationArchive {
    private File directory;
    private List<ApplicationArchive.Entry> entries;

    public DirectoryApplicationArchive(File directory) {
        Assert.notNull((Object)directory, (String)"Directory must not be null");
        Assert.isTrue((boolean)directory.isDirectory(), (String)"File must reference a directory");
        this.directory = directory;
        ArrayList<ApplicationArchive.Entry> entries = new ArrayList<ApplicationArchive.Entry>();
        this.collectEntries(entries, directory);
        this.entries = Collections.unmodifiableList(entries);
    }

    private void collectEntries(List<ApplicationArchive.Entry> entries, File directory) {
        for (File child : directory.listFiles()) {
            if (this.exclude(child)) continue;
            entries.add(new EntryAdapter(child));
            if (!child.isDirectory()) continue;
            this.collectEntries(entries, child);
        }
    }

    private boolean exclude(File file) {
        return file.getName().startsWith(".git") || file.getName().startsWith(".svn") || file.getName().startsWith(".darcs");
    }

    @Override
    public String getFilename() {
        return this.directory.getName();
    }

    @Override
    public Iterable<ApplicationArchive.Entry> getEntries() {
        return this.entries;
    }

    private class EntryAdapter
    extends AbstractApplicationArchiveEntry {
        private File file;
        private String name;

        public EntryAdapter(File file) {
            this.file = file;
            this.name = file.getAbsolutePath().substring(DirectoryApplicationArchive.this.directory.getAbsolutePath().length() + 1);
            if (this.isDirectory()) {
                this.name = this.name + File.separatorChar;
            }
        }

        @Override
        public boolean isDirectory() {
            return this.file.isDirectory();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.isDirectory()) {
                return null;
            }
            return new FileInputStream(this.file);
        }
    }
}

