/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.cloudfoundry.client.lib.ApplicationLogListener;
import org.cloudfoundry.client.lib.CloudOperationException;
import org.cloudfoundry.client.lib.rest.LoggregatorEndpoint;
import org.cloudfoundry.client.lib.rest.StreamingLogTokenImpl;
import org.springframework.web.util.UriTemplate;

public class LoggregatorClient {
    private static final UriTemplate loggregatorStreamUriTemplate = new UriTemplate("{endpoint}/{kind}/?app={appId}");
    private static final UriTemplate loggregatorRecentUriTemplate = new UriTemplate("{scheme}://{host}/recent");
    private boolean trustSelfSignedCerts;

    public LoggregatorClient(boolean trustSelfSignedCerts) {
        this.trustSelfSignedCerts = trustSelfSignedCerts;
    }

    public String getRecentHttpEndpoint(String endpoint) {
        URI uri = this.stringToUri(endpoint);
        String scheme = uri.getScheme();
        String host = uri.getHost();
        scheme = "wss".equals(scheme) ? "https" : "http";
        return loggregatorRecentUriTemplate.expand(new Object[]{scheme, host}).toString();
    }

    private URI stringToUri(String endPoint) {
        try {
            return new URI(endPoint);
        }
        catch (URISyntaxException e) {
            throw new CloudOperationException("Unable to parse Loggregator endpoint " + endPoint);
        }
    }

    public StreamingLogTokenImpl connectToLoggregator(String endpoint, String mode, UUID appId, ApplicationLogListener listener, ClientEndpointConfig.Configurator configurator) {
        URI loggregatorUri = loggregatorStreamUriTemplate.expand(new Object[]{endpoint, mode, appId});
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            ClientEndpointConfig config = this.buildClientConfig(configurator);
            Session session = container.connectToServer((Endpoint)new LoggregatorEndpoint(listener), config, loggregatorUri);
            return new StreamingLogTokenImpl(session);
        }
        catch (DeploymentException e) {
            throw new CloudOperationException(e);
        }
        catch (IOException e) {
            throw new CloudOperationException(e);
        }
    }

    private ClientEndpointConfig buildClientConfig(ClientEndpointConfig.Configurator configurator) {
        ClientEndpointConfig config = ClientEndpointConfig.Builder.create().configurator(configurator).build();
        if (this.trustSelfSignedCerts) {
            SSLContext sslContext = this.buildSslContext();
            Map userProperties = config.getUserProperties();
            userProperties.put("org.apache.tomcat.websocket.SSL_CONTEXT", sslContext);
        }
        return config;
    }

    private SSLContext buildSslContext() {
        try {
            SSLContextBuilder contextBuilder = new SSLContextBuilder().useTLS().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            return contextBuilder.build();
        }
        catch (GeneralSecurityException e) {
            throw new CloudOperationException(e);
        }
    }
}

