/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class CloudUtil {
    public static final int BUFFER_SIZE = 16384;
    private static Double DEFAULT_DOUBLE = new Double(0.0);
    private static Integer DEFAULT_INTEGER = new Integer(0);
    private static Long DEFAULT_LONG = new Long(0L);
    private static final String HEX_CHARS = "0123456789ABCDEF";
    private static final char EXTENSION_SEPARATOR = '.';

    public static String parse(Object object) {
        return CloudUtil.parse(String.class, object);
    }

    private CloudUtil() {
        throw new AssertionError((Object)"Helper class should not be instantiated.");
    }

    public static <T> T parse(Class<T> clazz, Object object) {
        Number defaultValue = null;
        try {
            if (clazz == Date.class) {
                String stringValue = CloudUtil.parse(String.class, object);
                return clazz.cast(new SimpleDateFormat("EEE MMM d HH:mm:ss Z yyyy", Locale.US).parse(stringValue));
            }
            if (clazz == Integer.class) {
                defaultValue = DEFAULT_INTEGER;
            } else if (clazz == Long.class) {
                defaultValue = DEFAULT_LONG;
            } else if (clazz == Double.class) {
                defaultValue = DEFAULT_DOUBLE;
            }
            if (object == null) {
                return (T)defaultValue;
            }
            if (clazz == Integer.class) {
                if (object instanceof Number) {
                    return clazz.cast(((Number)object).intValue());
                }
                if (object instanceof String) {
                    return clazz.cast(Integer.valueOf((String)object));
                }
            }
            if (clazz == Long.class) {
                if (object instanceof Number) {
                    return clazz.cast(((Number)object).longValue());
                }
                if (object instanceof String) {
                    return clazz.cast(Long.valueOf((String)object));
                }
            }
            if (clazz == Double.class) {
                if (object instanceof Number) {
                    return clazz.cast(((Number)object).doubleValue());
                }
                if (object instanceof String) {
                    return clazz.cast(Double.valueOf((String)object));
                }
            }
            return clazz.cast(object);
        }
        catch (ClassCastException e) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return (T)defaultValue;
    }

    public static boolean isWar(String filePath) {
        return "war".equalsIgnoreCase(CloudUtil.extension(filePath));
    }

    public static String computeSha1Digest(InputStream in) throws IOException {
        int read;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] buffer = new byte[16384];
        while ((read = in.read(buffer)) != -1) {
            digest.update(buffer, 0, read);
        }
        in.close();
        return CloudUtil.bytesToHex(digest.digest());
    }

    private static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            hex.append(HEX_CHARS.charAt((b & 0xF0) >> 4)).append(HEX_CHARS.charAt(b & 0xF));
        }
        return hex.toString();
    }

    private static String extension(String filePath) {
        int dot = filePath.lastIndexOf(46);
        return filePath.substring(dot + 1);
    }
}

