/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.plugin.execute;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;

public class MavenUtility {
    public final ArtifactResolver artifactResolver;
    public final ArtifactFactory artifactFactory;
    public final ArtifactMetadataSource artifactMetadataSource;
    public final ArtifactHandlerManager artifactHandlerManager;
    public final ArtifactRepository localRepository;
    public final List remoteRepositories;
    public final MavenProjectHelper projectHelper;
    public final MavenProjectBuilder projectBuilder;
    public final MavenProject project;
    public final MavenSession session;

    public MavenUtility(ArtifactResolver artifactResolver, ArtifactFactory artifactFactory, ArtifactMetadataSource artifactMetadataSource, ArtifactHandlerManager artifactHandlerManager, ArtifactRepository localRepository, List remoteRepositories, MavenProjectHelper projectHelper, MavenProjectBuilder projectBuilder, MavenProject project, MavenSession session) {
        this.artifactResolver = artifactResolver;
        this.artifactFactory = artifactFactory;
        this.artifactMetadataSource = artifactMetadataSource;
        this.artifactHandlerManager = artifactHandlerManager;
        this.localRepository = localRepository;
        this.remoteRepositories = remoteRepositories;
        this.projectHelper = projectHelper;
        this.projectBuilder = projectBuilder;
        this.project = project;
        this.session = session;
    }

    public File resolveArtifact(String id) throws ArtifactResolutionException, ArtifactNotFoundException {
        String[] tokens = id.split(":");
        String classifier = tokens.length >= 4 ? tokens[3] : null;
        String type = tokens.length >= 5 ? tokens[4] : "jar";
        Artifact a = this.artifactFactory.createArtifactWithClassifier(tokens[0], tokens[1], tokens[2], type, classifier);
        this.artifactResolver.resolve(a, this.remoteRepositories, this.localRepository);
        return a.getFile();
    }

    public void attachArtifact(File artifact, String classifier) {
        this.projectHelper.attachArtifact(this.project, classifier, artifact);
    }

    public void attachArtifact(File artifact) {
        this.project.getArtifact().setFile(artifact);
    }
}

