/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.plugin.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.annotation.Nullable;
import org.codehaus.gmaven.plugin.util.VersionHelper;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=MavenVersionHelper.class)
public class MavenVersionHelper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private VersionHelper versionHelper;

    public MavenVersionHelper() {
    }

    @VisibleForTesting
    public MavenVersionHelper(VersionHelper versionHelper) {
        this.versionHelper = (VersionHelper)Preconditions.checkNotNull((Object)versionHelper);
    }

    @Nullable
    public Version detectVersion(ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)classLoader);
        this.log.trace("Detecting Maven version; class-loader: {}", (Object)classLoader);
        Properties props = this.readProperties(classLoader, "org.apache.maven.cli.MavenCli", "/org/apache/maven/messages/build.properties");
        String raw = props.getProperty("version");
        this.log.trace("Raw version: {}", (Object)raw);
        if (raw == null) {
            return null;
        }
        Version version = this.versionHelper.parseVersion(raw);
        this.log.trace("Version: {}", (Object)version);
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties(ClassLoader classLoader, String className, String resourceName) {
        Properties props;
        block6: {
            this.log.trace("Reading properties; class-loader: {}, class-name: {}, resource-name: {}", new Object[]{classLoader, className, resourceName});
            props = new Properties();
            try {
                Class<?> type = classLoader.loadClass(className);
                this.log.trace("Type: {}", type);
                URL resource = type.getResource(resourceName);
                this.log.trace("Resource: {}", (Object)resource);
                if (resource == null) break block6;
                InputStream stream = resource.openStream();
                try {
                    props.load(stream);
                }
                finally {
                    stream.close();
                }
            }
            catch (ClassNotFoundException e) {
                this.log.trace("Failed to resolve class", (Throwable)e);
            }
            catch (IOException e) {
                this.log.trace("Failed to read properties", (Throwable)e);
            }
        }
        return props;
    }
}

