/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.runtime.support.stubgen.model;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.gmaven.runtime.support.stubgen.UnexpectedNodeException;
import org.codehaus.gmaven.runtime.support.stubgen.model.AnnotationDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.ClassDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.ConstructorDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.EnumDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.FieldDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.ImportDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.InterfaceDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.JavaDocAware;
import org.codehaus.gmaven.runtime.support.stubgen.model.JavaDocDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.JavaDocParser;
import org.codehaus.gmaven.runtime.support.stubgen.model.MethodDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.ModelFactory;
import org.codehaus.gmaven.runtime.support.stubgen.model.ModifiersAware;
import org.codehaus.gmaven.runtime.support.stubgen.model.ModifiersDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.NameAware;
import org.codehaus.gmaven.runtime.support.stubgen.model.PackageDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.ParameterDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.ParametersAware;
import org.codehaus.gmaven.runtime.support.stubgen.model.SourceDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.SuperParameterDef;
import org.codehaus.gmaven.runtime.support.stubgen.model.ThrowsAware;
import org.codehaus.gmaven.runtime.support.stubgen.model.TypeDef;
import org.codehaus.gmaven.runtime.support.stubgen.parser.Node;
import org.codehaus.gmaven.runtime.support.stubgen.parser.Parser;
import org.codehaus.gmaven.runtime.support.stubgen.parser.ParserFactory;
import org.codehaus.gmaven.runtime.support.stubgen.parser.SourceType;

public abstract class ModelFactorySupport
implements ModelFactory {
    protected final ParserFactory factory;
    protected Parser parser;
    protected Node lastNode;
    protected SourceDef source;
    protected ClassDef clazz;
    private static JavaDocParser javaDocParser;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ModelFactorySupport(ParserFactory factory) {
        if (!$assertionsDisabled && factory == null) {
            throw new AssertionError();
        }
        this.factory = factory;
    }

    public SourceDef create(URL input) throws Exception {
        return this.create(input, Charset.defaultCharset().name());
    }

    public SourceDef create(URL input, SourceType type) throws Exception {
        return this.create(input, Charset.defaultCharset().name(), type);
    }

    public SourceDef create(URL input, String encoding) throws Exception {
        if (!$assertionsDisabled && input == null) {
            throw new AssertionError();
        }
        return this.create(input, encoding, SourceType.forURL(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceDef create(URL input, String encoding, SourceType type) throws Exception {
        Node node;
        if (!$assertionsDisabled && input == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        this.source = this.createRoot(input, type);
        this.lastNode = null;
        this.clazz = null;
        this.parser = this.factory.create(this.source.getType());
        BufferedReader reader = encoding != null ? new BufferedReader(new InputStreamReader(input.openStream(), encoding)) : new BufferedReader(new InputStreamReader(input.openStream()));
        try {
            node = this.parser.parse(reader, input.toExternalForm());
        }
        finally {
            ((Reader)reader).close();
        }
        this.process(node);
        return this.source;
    }

    protected SourceDef createRoot(URL input, SourceType type) {
        if (!$assertionsDisabled && input == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        SourceDef def = new SourceDef();
        def.setUrl(input);
        def.setType(type);
        this.addDefaultImports(def);
        return def;
    }

    protected abstract void addDefaultImports(SourceDef var1);

    protected void process(Node node) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        while (node != null) {
            if (node.is("PACKAGE_DEF")) {
                this.packageDef(node);
            } else if (node.is(new String[]{"STATIC_IMPORT", "IMPORT"})) {
                this.importDef(node);
            } else if (node.is("CLASS_DEF")) {
                this.classDef(node);
            } else if (node.is("INTERFACE_DEF")) {
                this.interfaceDef(node);
            } else if (node.is("METHOD_DEF")) {
                this.methodDef(node);
            } else if (node.is("ENUM_DEF")) {
                this.enumDef(node);
            } else if (node.is("ANNOTATION_DEF")) {
                this.annotationDef(node);
            } else {
                this.source.addStatement(node);
            }
            node = node.nextSibling();
        }
    }

    protected void packageDef(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        PackageDef def = new PackageDef();
        Node node = parent.firstChild();
        node = node.skip("ANNOTATIONS");
        String name = this.qualifiedName(node);
        def.setName(name);
        this.source.setPackage(def);
    }

    protected void importDef(Node parent) {
        Node node;
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        ImportDef def = new ImportDef();
        if (parent.is("STATIC_IMPORT")) {
            def.setStatic(true);
        }
        if ((node = parent.firstChild()).is("LITERAL_as")) {
            node = node.firstChild();
            Node aliasNode = node.nextSibling();
            def.setAlias(this.identifier(aliasNode));
        }
        if (node.isLeaf()) {
            def.setType(this.identifier(node));
        } else {
            Node packageNode = node.firstChild();
            String packageName = this.qualifiedName(packageNode);
            def.setPackage(packageName);
            Node nameNode = packageNode.nextSibling();
            if (nameNode.is("STAR")) {
                def.setWildcard(true);
            } else {
                String name = this.identifier(nameNode);
                def.setType(name);
            }
        }
        this.source.addImport(def);
    }

    protected void interfaceDef(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        InterfaceDef def = new InterfaceDef();
        this.clazz = def;
        Node node = parent.firstChild();
        node = this.modifiers(def, node);
        if ((node = this.name(def, node)).is("EXTENDS_CLAUSE")) {
            def.getImplements().addAll(this.interfaces(node));
            node = node.nextSibling();
        }
        this.javadocs(def, parent);
        this.objectBlock(node);
        this.source.addClass(def);
    }

    protected void classDef(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        ClassDef def = new ClassDef();
        def.addImplements("groovy.lang.GroovyObject");
        this.clazz = def;
        Node node = parent.firstChild();
        node = this.modifiers(def, node);
        node = this.name(def, node);
        if (node.is("TYPE_PARAMETERS")) {
            node = node.nextSibling();
        }
        if (node.is("EXTENDS_CLAUSE")) {
            def.setSuperClass(this.type(node));
            node = node.nextSibling();
        }
        if (node.is("IMPLEMENTS_CLAUSE")) {
            def.getImplements().addAll(this.interfaces(node));
            node = node.nextSibling();
        }
        this.javadocs(def, parent);
        this.objectBlock(node);
        this.source.addClass(def);
    }

    protected void enumDef(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        parent.ensure("ENUM_DEF");
        EnumDef def = new EnumDef();
        this.clazz = def;
        Node node = parent.firstChild();
        node = this.modifiers(def, node);
        node = this.name(def, node);
        if (node.is("TYPE_PARAMETERS")) {
            node = node.nextSibling();
        }
        if (node.is("EXTENDS_CLAUSE")) {
            def.setSuperClass(this.type(node));
            node = node.nextSibling();
        }
        if (node.is("IMPLEMENTS_CLAUSE")) {
            def.getImplements().addAll(this.interfaces(node));
            node = node.nextSibling();
        }
        this.javadocs(def, parent);
        this.objectBlock(node);
        this.source.addClass(def);
    }

    protected void annotationDef(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        parent.ensure("ANNOTATION_DEF");
        AnnotationDef def = new AnnotationDef();
        this.clazz = def;
        Node node = parent.firstChild();
        node = this.modifiers(def, node);
        node = this.name(def, node);
        if (node.is("TYPE_PARAMETERS")) {
            node = node.nextSibling();
        }
        if (node.is("EXTENDS_CLAUSE")) {
            def.getImplements().addAll(this.interfaces(node));
            node = node.nextSibling();
        }
        this.javadocs(def, parent);
        this.objectBlock(node);
        this.source.addClass(def);
    }

    protected void objectBlock(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        parent.ensure("OBJBLOCK");
        for (Node node = parent.firstChild(); node != null; node = node.nextSibling()) {
            if (node.is("OBJBLOCK")) {
                this.objectBlock(node);
                continue;
            }
            if (node.is("METHOD_DEF")) {
                this.methodDef(node);
                continue;
            }
            if (node.is("ANNOTATION_FIELD_DEF")) {
                this.annotationFieldDef(node);
                continue;
            }
            if (node.is("CTOR_IDENT")) {
                this.constructorDef(node);
                continue;
            }
            if (node.is("VARIABLE_DEF")) {
                this.fieldDef(node);
                continue;
            }
            if (node.is("ENUM_DEF")) {
                this.enumDef(node);
                continue;
            }
            if (node.is("ENUM_CONSTANT_DEF")) {
                this.enumConstantDef(node);
                continue;
            }
            if (node.is(new String[]{"STATIC_INIT", "INSTANCE_INIT"})) continue;
            throw new UnexpectedNodeException(node);
        }
    }

    protected void constructorDef(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        ConstructorDef def = new ConstructorDef();
        Node node = parent.firstChild();
        node = this.modifiers(def, node);
        node = this.parameters(def, node);
        node = this.throwz(def, node);
        this.superParameters(def, node);
        this.javadocs(def, parent);
        this.clazz.addConstructor(def);
    }

    protected void superParameters(ConstructorDef target, Node parent) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        Node node = parent;
        if (node.is("SLIST") && (node = node.firstChild()) != null && node.is(new String[]{"SUPER_CTOR_CALL", "CTOR_CALL"})) {
            if (node.is("SUPER_CTOR_CALL")) {
                target.setSuperType("super");
            } else {
                target.setSuperType("this");
            }
            node = node.firstChild();
            node.ensure("ELIST");
            if (!node.isLeaf()) {
                node = node.firstChild();
                do {
                    this.superParameter(target, node);
                } while ((node = node.nextSibling()) != null);
            }
        }
    }

    protected void superParameter(ConstructorDef target, Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        parent.ensure("EXPR");
        Node node = parent.firstChild();
        SuperParameterDef def = new SuperParameterDef();
        if (node.is("TYPECAST")) {
            node = node.firstChild();
            if (!$assertionsDisabled && node == null) {
                throw new AssertionError();
            }
            node.ensure("TYPE");
            def.setType(this.type(node));
        } else if (node.is("LITERAL_as")) {
            node = node.firstChild();
            if (!$assertionsDisabled && node == null) {
                throw new AssertionError();
            }
            node = node.nextSibling();
            if (!$assertionsDisabled && node == null) {
                throw new AssertionError();
            }
            node.ensure("TYPE");
            def.setType(this.type(node));
        } else if (node.is("LITERAL_new")) {
            node = node.firstChild();
            if (!$assertionsDisabled && node == null) {
                throw new AssertionError();
            }
            def.setType(this.type(node));
        } else if (node.is(new String[]{"LITERAL_true", "LITERAL_false"})) {
            def.setType("boolean");
        } else if (node.is("STRING_LITERAL")) {
            def.setType(TypeDef.STRING);
        } else if (node.is("NUM_INT")) {
            def.setType("int");
        } else if (node.is("NUM_LONG")) {
            def.setType("long");
        } else if (node.is("NUM_FLOAT")) {
            def.setType("float");
        } else if (node.is("NUM_DOUBLE")) {
            def.setType("double");
        } else if (node.is("NUM_BIG_INT")) {
            def.setType(TypeDef.BIG_INT);
        } else if (node.is("NUM_BIG_DECIMAL")) {
            def.setType(TypeDef.BIG_DECIMAL);
        } else if (node.is("STRING_CONSTRUCTOR")) {
            def.setType(TypeDef.STRING);
        } else if (node.is("IDENT")) {
            String ident = node.text();
            Set parameters = target.getParameters();
            if (!parameters.isEmpty()) {
                Iterator iter = parameters.iterator();
                while (iter.hasNext()) {
                    ParameterDef param = (ParameterDef)iter.next();
                    String name = param.getName();
                    if (name == null || !name.equals(ident)) continue;
                    def.setType(param.getType());
                    break;
                }
            }
        }
        target.addSuperParameter(def);
    }

    protected void methodDef(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        MethodDef def = new MethodDef();
        Node node = parent.firstChild();
        if (node.is("TYPE_PARAMETERS")) {
            node = node.nextSibling();
        }
        if ((node = this.modifiers(def, node)).is("TYPE")) {
            def.setReturns(this.type(node));
            node = node.nextSibling();
        } else {
            def.setReturns(new TypeDef());
        }
        node = this.name(def, node);
        node = this.parameters(def, node);
        node = this.throwz(def, node);
        if (node != null) {
            node.skip("SLIST");
        }
        this.javadocs(def, parent);
        this.clazz.addMethod(def);
    }

    protected void annotationFieldDef(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        MethodDef def = new MethodDef();
        Node node = parent.firstChild();
        if (node.is("TYPE_PARAMETERS")) {
            node = node.nextSibling();
        }
        if ((node = this.modifiers(def, node)).is("TYPE")) {
            def.setReturns(this.type(node));
            node = node.nextSibling();
        } else {
            def.setReturns(new TypeDef());
        }
        node = this.name(def, node);
        this.javadocs(def, parent);
        this.clazz.addMethod(def);
    }

    protected void fieldDef(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        FieldDef def = new FieldDef();
        Node node = parent.firstChild();
        if ((node = this.modifiers(def, node)).is("TYPE")) {
            def.setType(this.type(node));
            node = node.nextSibling();
        } else {
            def.setType(new TypeDef());
        }
        this.name(def, node);
        this.javadocs(def, parent);
        this.clazz.addField(def);
    }

    protected void enumConstantDef(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        parent.ensure("ENUM_CONSTANT_DEF");
        if (!$assertionsDisabled && !(this.clazz instanceof EnumDef)) {
            throw new AssertionError();
        }
        EnumDef def = (EnumDef)this.clazz;
        Node node = parent.firstChild();
        if (node.is("ANNOTATIONS")) {
            node = node.nextSibling();
        }
        String name = this.identifier(node);
        def.addConstant(name);
    }

    protected Node name(NameAware target, Node node) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        target.setName(this.identifier(node));
        return node.nextSibling();
    }

    protected Node modifiers(ModifiersAware target, Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        if (!parent.is("MODIFIERS")) {
            return parent;
        }
        ModifiersDef def = new ModifiersDef();
        for (Node node = parent.firstChild(); node != null; node = node.nextSibling()) {
            if (node.is(new String[]{"STRICTFP", "STATIC_IMPORT"})) {
                // empty if block
            }
            if (node.is("ANNOTATION")) continue;
            if (node.is("LITERAL_private")) {
                def.add("private");
                continue;
            }
            if (node.is("LITERAL_protected")) {
                def.add("protected");
                continue;
            }
            if (node.is("LITERAL_public")) {
                def.add("public");
                continue;
            }
            if (node.is("ABSTRACT")) {
                def.add("abstract");
                continue;
            }
            if (node.is("FINAL")) {
                def.add("final");
                continue;
            }
            if (node.is("LITERAL_native")) {
                def.add("native");
                continue;
            }
            if (node.is("LITERAL_static")) {
                def.add("static");
                continue;
            }
            if (node.is("LITERAL_synchronized")) {
                def.add("synchronized");
                continue;
            }
            if (node.is("LITERAL_transient")) {
                def.add("transient");
                continue;
            }
            if (node.is("LITERAL_volatile")) {
                def.add("volatile");
                continue;
            }
            throw new UnexpectedNodeException(node);
        }
        target.getModifiers().merge(def);
        return parent.nextSibling();
    }

    protected Set interfaces(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        LinkedHashSet<TypeDef> set = new LinkedHashSet<TypeDef>();
        for (Node node = parent.firstChild(); node != null; node = node.nextSibling()) {
            set.add(this.type(node));
        }
        return set;
    }

    protected Node throwz(ThrowsAware target, Node parent) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (parent == null) {
            return null;
        }
        if (!parent.is("LITERAL_throws")) {
            return parent;
        }
        Node node = parent.firstChild();
        if (node != null) {
            do {
                target.getThrows().add(this.type(node));
            } while ((node = node.nextSibling()) != null);
        }
        return parent.nextSibling();
    }

    protected Node parameters(ParametersAware target, Node parent) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        parent.ensure("PARAMETERS");
        Node node = parent.firstChild();
        if (node != null) {
            do {
                target.addParameter(this.parameter(node));
            } while ((node = node.nextSibling()) != null);
        }
        return parent.nextSibling();
    }

    protected ParameterDef parameter(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        ParameterDef def = new ParameterDef();
        Node node = parent.firstChild();
        if ((node = this.modifiers(def, node)).is("TYPE")) {
            def.setType(this.type(node));
            node = node.nextSibling();
        } else {
            def.setType(new TypeDef());
        }
        def.setName(this.identifier(node));
        return def;
    }

    protected TypeDef type(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        TypeDef def = new TypeDef();
        Node node = parent.is(new String[]{"IDENT", "DOT"}) ? parent : parent.firstChild();
        if (node != null) {
            int dim = 0;
            while (node.is("ARRAY_DECLARATOR")) {
                node = node.firstChild();
                ++dim;
            }
            def.setDimensions(dim);
            def.setName(this.qualifiedName(node));
        }
        return def;
    }

    protected void javadocs(JavaDocAware target, Node node) {
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        String text = this.parser.snippet(this.lastNode, node);
        this.lastNode = node;
        JavaDocDef def = javaDocParser.parse(text);
        if (def != null) {
            target.setJavaDoc(def);
        }
    }

    protected String qualifiedName(Node parent) {
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        if (parent.is("IDENT")) {
            return parent.text();
        }
        if (parent.is("DOT")) {
            StringBuffer buff = new StringBuffer();
            boolean first = true;
            for (Node node = parent.firstChild(); node != null; node = node.nextSibling()) {
                if (first) {
                    first = false;
                } else {
                    buff.append(".");
                }
                buff.append(this.qualifiedName(node));
            }
            return buff.toString();
        }
        return parent.text();
    }

    protected String identifier(Node node) {
        if (!$assertionsDisabled && node == null) {
            throw new AssertionError();
        }
        node.ensure("IDENT");
        return node.text();
    }

    static {
        $assertionsDisabled = !ModelFactorySupport.class.desiredAssertionStatus();
        javaDocParser = new JavaDocParser();
    }
}

