/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportNodeCompatibilityWrapper {
    private SortedSet<ImportNode> sortedImports;
    private ModuleNode module;

    public ImportNodeCompatibilityWrapper(ModuleNode module) {
        if (module == null) {
            throw new IllegalArgumentException("Module node should not be null");
        }
        this.module = module;
    }

    public SortedSet<ImportNode> getAllImportNodes() {
        if (this.sortedImports == null) {
            this.initialize();
        }
        return this.sortedImports;
    }

    private void initialize() {
        this.sortedImports = new TreeSet<ImportNode>(new ImportNodeComparator());
        this.sortedImports.addAll(this.module.getImports());
        this.sortedImports.addAll(this.module.getStarImports());
        this.sortedImports.addAll(this.module.getStaticStarImports().values());
        this.sortedImports.addAll(this.module.getStaticImports().values());
    }

    public static String getFieldName(ImportNode node) {
        return node.getFieldName();
    }

    public static Map<String, ImportNode> getStaticImports(ModuleNode node) {
        return node.getStaticImports();
    }

    public static Map<String, ImportNode> getStaticStarImports(ModuleNode node) {
        return node.getStaticStarImports();
    }

    public static List<ImportNode> getStarImports(ModuleNode node) {
        return node.getStarImports();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImportNodeComparator
    implements Comparator<ImportNode> {
        private ImportNodeComparator() {
        }

        @Override
        public int compare(ImportNode i1, ImportNode i2) {
            int start2;
            int start1 = i1.getStart();
            if (start1 <= 0 && i1.getType() != null) {
                start1 = i1.getType().getStart();
            }
            if ((start2 = i2.getStart()) <= 0 && i2.getType() != null) {
                start2 = i2.getType().getStart();
            }
            return start1 - start2;
        }
    }
}

