/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Method;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SettableBeanProperty {
    final String _propName;
    final Method _setter;
    final JavaType _type;
    JsonDeserializer<Object> _valueDeserializer;

    public SettableBeanProperty(String propName, JavaType type, Method setter) {
        this._propName = propName.intern();
        this._type = type;
        this._setter = setter;
    }

    public void setValueDeserializer(JsonDeserializer<Object> deser) {
        if (this._valueDeserializer != null) {
            throw new IllegalStateException("Alread had assigned deserializer for property '" + this._propName + "' (class " + this._setter.getDeclaringClass().getName() + ")");
        }
        this._valueDeserializer = deser;
    }

    public String getPropertyName() {
        return this._propName;
    }

    public JavaType getType() {
        return this._type;
    }

    public JsonDeserializer<Object> getValueDeserializer() {
        return this._valueDeserializer;
    }

    public void set(Object instance, Object value) {
        try {
            this._setter.invoke(instance, value);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            Throwable t = e;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            throw new IllegalArgumentException(t.getMessage(), t);
        }
    }

    public String toString() {
        return "[property '" + this._propName + "]";
    }
}

