/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.deser.ArrayDeserializer;
import org.codehaus.jackson.map.deser.ArrayDeserializers;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.codehaus.jackson.map.deser.CollectionDeserializer;
import org.codehaus.jackson.map.deser.EnumDeserializer;
import org.codehaus.jackson.map.deser.EnumMapDeserializer;
import org.codehaus.jackson.map.deser.EnumResolver;
import org.codehaus.jackson.map.deser.EnumSetDeserializer;
import org.codehaus.jackson.map.deser.MapDeserializer;
import org.codehaus.jackson.map.deser.SettableBeanProperty;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.JavaType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.SimpleType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdDeserializerFactory
extends DeserializerFactory {
    static final JavaType _typeString = TypeFactory.instance.fromClass(String.class);
    static final HashMap<String, Class<? extends Map>> _mapFallbacks = new HashMap();
    static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
    static final HashMap<JavaType, JsonDeserializer<Object>> _arrayDeserializers;
    public static final StdDeserializerFactory instance;

    protected StdDeserializerFactory() {
    }

    public JsonDeserializer<Object> createArrayDeserializer(ArrayType type, DeserializerProvider p) {
        JavaType elemType = type.getComponentType();
        JsonDeserializer<Object> deser = _arrayDeserializers.get(elemType);
        if (deser != null) {
            return deser;
        }
        if (elemType.isPrimitive()) {
            throw new IllegalArgumentException("Internal error: primitive type (" + type + ") passed, no array deserializer found");
        }
        JsonDeserializer<Object> valueDes = p.findValueDeserializer(elemType, this);
        return new ArrayDeserializer(type, valueDes);
    }

    @Override
    public JsonDeserializer<?> createMapDeserializer(MapType type, DeserializerProvider p) {
        KeyDeserializer keyDes;
        JavaType keyType = type.getKeyType();
        JavaType valueType = type.getValueType();
        JsonDeserializer<Object> valueDes = p.findValueDeserializer(valueType, this);
        Class<Object> mapClass = type.getRawClass();
        if (EnumMap.class.isAssignableFrom(mapClass)) {
            return new EnumMapDeserializer(EnumResolver.constructFor(keyType.getRawClass()), valueDes);
        }
        KeyDeserializer keyDeserializer = keyDes = _typeString.equals(keyType) ? null : p.findKeyDeserializer(keyType);
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Map> fallback = _mapFallbacks.get(mapClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Map type " + type);
            }
            mapClass = fallback;
        }
        return new MapDeserializer(mapClass, keyDes, valueDes);
    }

    @Override
    public JsonDeserializer<?> createCollectionDeserializer(CollectionType type, DeserializerProvider p) {
        JavaType valueType = type.getElementType();
        Class<Object> collectionClass = type.getRawClass();
        if (EnumSet.class.isAssignableFrom(collectionClass)) {
            return new EnumSetDeserializer(EnumResolver.constructFor(valueType.getRawClass()));
        }
        JsonDeserializer<Object> valueDes = p.findValueDeserializer(valueType, this);
        if (type.isInterface() || type.isAbstract()) {
            Class<? extends Collection> fallback = _collectionFallbacks.get(collectionClass.getName());
            if (fallback == null) {
                throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + type);
            }
            collectionClass = fallback;
        }
        return new CollectionDeserializer(collectionClass, valueDes);
    }

    public JsonDeserializer<Object> createBeanDeserializer(JavaType type, DeserializerProvider p) {
        Class<?> beanClass = type.getRawClass();
        if (!this.isPotentialBeanType(beanClass)) {
            return null;
        }
        Constructor<?>[] ctors = beanClass.getDeclaredConstructors();
        List<Method> staticMethods = this.findStaticFactoryMethods(beanClass);
        BeanDeserializer.StringConstructor sctor = this.constructStringConstructor(beanClass, ctors, staticMethods);
        BeanDeserializer.NumberConstructor nctor = this.constructNumberConstructor(beanClass, ctors, staticMethods);
        Constructor<?> defaultCtor = this.findDefaultConstructor(ctors);
        if (sctor == null && nctor == null && defaultCtor == null) {
            throw new IllegalArgumentException("Can not create Bean deserializer for (" + type + "): neither default constructor nor factory methods found");
        }
        if (defaultCtor != null) {
            ClassUtil.checkAndFixAccess(defaultCtor, beanClass);
        }
        BeanDeserializer deser = new BeanDeserializer(beanClass, defaultCtor, sctor, nctor);
        this.addBeanProps(deser);
        return deser;
    }

    public JsonDeserializer<Object> createEnumDeserializer(SimpleType type, DeserializerProvider p) {
        EnumDeserializer des;
        EnumDeserializer result = des = new EnumDeserializer(EnumResolver.constructFor(type.getRawClass()));
        return result;
    }

    protected void addBeanProps(BeanDeserializer deser) {
        LinkedHashMap<String, Method> methods = new LinkedHashMap<String, Method>();
        Class<?> beanClass = deser.getBeanClass();
        this.findCandidateMethods(beanClass, methods);
        for (Method m : methods.values()) {
            String name = this.okNameForMutator(m);
            if (name == null) continue;
            ClassUtil.checkAndFixAccess(m, m.getDeclaringClass());
            Type rawType = m.getGenericParameterTypes()[0];
            JavaType type = TypeFactory.instance.fromType(rawType);
            SettableBeanProperty prop = new SettableBeanProperty(name, type, m);
            SettableBeanProperty oldP = deser.addSetter(prop);
            if (oldP == null) continue;
            throw new IllegalArgumentException("Duplicate property '" + name + "' for class " + beanClass.getName());
        }
    }

    protected void findCandidateMethods(Class<?> type, Map<String, Method> result) {
        Class<?> parent = type.getSuperclass();
        if (parent != null && parent != Object.class) {
            this.findCandidateMethods(parent, result);
        }
        for (Method m : type.getDeclaredMethods()) {
            if (!this.okSignatureForMutator(m)) continue;
            result.put(m.getName(), m);
        }
    }

    protected boolean okSignatureForMutator(Method m) {
        if (Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        Class<?>[] pts = m.getParameterTypes();
        return pts != null && pts.length == 1;
    }

    protected String okNameForMutator(Method m) {
        String name = m.getName();
        if (name.startsWith("set")) {
            if ((name = this.mangleName(m, name.substring(3))) == null) {
                return null;
            }
            return name;
        }
        return null;
    }

    protected String mangleName(Method method, String basename) {
        return ClassUtil.manglePropertyName(basename);
    }

    BeanDeserializer.StringConstructor constructStringConstructor(Class<?> beanClass, Constructor<?>[] ctors, List<Method> staticMethods) {
        Constructor<?> sctor = null;
        for (Constructor<?> c : ctors) {
            Class<?>[] args = c.getParameterTypes();
            if (args.length != 1 || args[0] != String.class) continue;
            ClassUtil.checkAndFixAccess(c, beanClass);
            sctor = c;
            break;
        }
        Method factoryMethod = null;
        for (Method m : staticMethods) {
            Class<?> arg;
            if (!"valueOf".equals(m.getName()) || (arg = m.getParameterTypes()[0]) != String.class) continue;
            ClassUtil.checkAndFixAccess(m, beanClass);
            factoryMethod = m;
            break;
        }
        return new BeanDeserializer.StringConstructor(beanClass, sctor, factoryMethod);
    }

    BeanDeserializer.NumberConstructor constructNumberConstructor(Class<?> beanClass, Constructor<?>[] ctors, List<Method> staticMethods) {
        Constructor<?> intCtor = null;
        Constructor<?> longCtor = null;
        for (Constructor<?> c : ctors) {
            Class<?>[] args = c.getParameterTypes();
            if (args.length != 1) continue;
            Class<?> argType = args[0];
            if (argType == Integer.TYPE || argType == Integer.class) {
                ClassUtil.checkAndFixAccess(c, beanClass);
                intCtor = c;
                continue;
            }
            if (argType != Long.TYPE && argType != Long.class) continue;
            ClassUtil.checkAndFixAccess(c, beanClass);
            longCtor = c;
        }
        Method intFactoryMethod = null;
        Method longFactoryMethod = null;
        for (Method m : staticMethods) {
            if (!"valueOf".equals(m.getName())) continue;
            Class<?> argType = m.getParameterTypes()[0];
            if (argType == Integer.TYPE || argType == Integer.class) {
                ClassUtil.checkAndFixAccess(m, beanClass);
                intFactoryMethod = m;
                continue;
            }
            if (argType != Long.TYPE && argType != Long.class) continue;
            ClassUtil.checkAndFixAccess(m, beanClass);
            longFactoryMethod = m;
        }
        return new BeanDeserializer.NumberConstructor(beanClass, intCtor, longCtor, intFactoryMethod, longFactoryMethod);
    }

    protected Constructor<?> findDefaultConstructor(Constructor<?>[] ctors) {
        for (Constructor<?> ctor : ctors) {
            if (ctor.isVarArgs() || ctor.getParameterTypes().length != 0) continue;
            return ctor;
        }
        return null;
    }

    List<Method> findStaticFactoryMethods(Class<?> clz) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m : clz.getDeclaredMethods()) {
            Class<?> resultType;
            if (!Modifier.isStatic(m.getModifiers()) || !clz.isAssignableFrom(resultType = m.getReturnType()) || m.getParameterTypes().length != 1) continue;
            result.add(m);
        }
        return result;
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        String typeStr = ClassUtil.canBeABeanType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        if (ClassUtil.isProxyType(type)) {
            throw new IllegalArgumentException("Can not deserialize Proxy class " + type.getName() + " as a Bean");
        }
        typeStr = ClassUtil.isLocalType(type);
        if (typeStr != null) {
            throw new IllegalArgumentException("Can not deserialize Class " + type.getName() + " (of type " + typeStr + ") as a Bean");
        }
        return true;
    }

    static {
        _mapFallbacks.put(Map.class.getName(), LinkedHashMap.class);
        _mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        _mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        _mapFallbacks.put("java.util.NavigableMap", TreeMap.class);
        try {
            Class<?> key = Class.forName("java.util.ConcurrentNavigableMap");
            Class<?> value = Class.forName("java.util.ConcurrentSkipListMap");
            _mapFallbacks.put(key.getName(), value);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        _collectionFallbacks = new HashMap();
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), HashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
        _arrayDeserializers = ArrayDeserializers.getAll();
        instance = new StdDeserializerFactory();
    }
}

