/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerFactory;
import org.codehaus.jackson.map.ser.BeanSerializerFactory;
import org.codehaus.jackson.map.ser.ClassKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomSerializerFactory
extends SerializerFactory {
    final SerializerFactory _fallbackFactory;
    HashMap<ClassKey, JsonSerializer<?>> _directClassMappings = null;
    HashMap<ClassKey, JsonSerializer<?>> _transitiveClassMappings = null;
    HashMap<ClassKey, JsonSerializer<?>> _interfaceMappings = null;

    public CustomSerializerFactory() {
        this(BeanSerializerFactory.instance);
    }

    public CustomSerializerFactory(SerializerFactory fallbackFactory) {
        this._fallbackFactory = fallbackFactory;
    }

    public <T> void addGenericMapping(Class<T> type, JsonSerializer<T> ser) {
        ClassKey key = new ClassKey(type);
        if (type.isInterface()) {
            if (this._interfaceMappings == null) {
                this._interfaceMappings = new HashMap();
            }
            this._interfaceMappings.put(key, ser);
        } else {
            if (this._transitiveClassMappings == null) {
                this._transitiveClassMappings = new HashMap();
            }
            this._transitiveClassMappings.put(key, ser);
        }
    }

    public <T> void addSpecificMapping(Class<T> forClass, JsonSerializer<T> ser) {
        ClassKey key = new ClassKey(forClass);
        if (forClass.isInterface()) {
            throw new IllegalArgumentException("Can not add specific mapping for an interface (" + forClass.getName() + ")");
        }
        if (Modifier.isAbstract(forClass.getModifiers())) {
            throw new IllegalArgumentException("Can not add specific mapping for an abstract class (" + forClass.getName() + ")");
        }
        if (this._directClassMappings == null) {
            this._directClassMappings = new HashMap();
        }
        this._directClassMappings.put(key, ser);
    }

    @Override
    public <T> JsonSerializer<T> createSerializer(Class<T> type) {
        Class<T> curr;
        JsonSerializer<?> ser = null;
        ClassKey key = new ClassKey(type);
        if (this._directClassMappings != null) {
            ser = this._directClassMappings.get(key);
        }
        if (ser == null && this._transitiveClassMappings != null) {
            for (curr = type; curr != null && ser == null; curr = curr.getSuperclass()) {
                key.reset(curr);
                ser = this._transitiveClassMappings.get(key);
            }
        }
        if (ser == null && this._interfaceMappings != null) {
            block1: for (curr = type; curr != null && ser == null; curr = curr.getSuperclass()) {
                for (Class<?> iface : curr.getInterfaces()) {
                    key.reset(iface);
                    ser = this._interfaceMappings.get(key);
                    if (ser != null) continue block1;
                }
            }
        }
        if (ser == null && this._fallbackFactory != null) {
            return this._fallbackFactory.createSerializer(type);
        }
        return ser;
    }
}

