/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.util.ArrayBuilders;
import org.codehaus.jackson.map.util.ObjectBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdDeserializationContext
extends DeserializationContext {
    static final int MAX_ERROR_STR_LEN = 500;
    protected final JsonParser _parser;
    protected ArrayBuilders _arrayBuilders;
    protected ObjectBuffer _objectBuffer;
    protected DateFormat _dateFormat;

    public StdDeserializationContext(DeserializationConfig config, JsonParser jp) {
        super(config);
        this._parser = jp;
    }

    @Override
    public JsonParser getParser() {
        return this._parser;
    }

    @Override
    public final ObjectBuffer leaseObjectBuffer() {
        ObjectBuffer buf = this._objectBuffer;
        if (buf == null) {
            buf = new ObjectBuffer();
        } else {
            this._objectBuffer = null;
        }
        return buf;
    }

    @Override
    public final void returnObjectBuffer(ObjectBuffer buf) {
        if (this._objectBuffer == null || buf.initialCapacity() >= this._objectBuffer.initialCapacity()) {
            this._objectBuffer = buf;
        }
    }

    @Override
    public final ArrayBuilders getArrayBuilders() {
        if (this._arrayBuilders == null) {
            this._arrayBuilders = new ArrayBuilders();
        }
        return this._arrayBuilders;
    }

    @Override
    public Date parseDate(String dateStr) throws IllegalArgumentException {
        try {
            return this.getDateFormat().parse(dateStr);
        }
        catch (ParseException pex) {
            throw new IllegalArgumentException(pex.getMessage());
        }
    }

    @Override
    public Calendar constructCalendar(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c;
    }

    @Override
    public JsonMappingException mappingException(Class<?> targetClass) {
        String clsName = this._calcName(targetClass);
        return JsonMappingException.from(this._parser, "Can not deserialize instance of " + clsName + " out of " + this._parser.getCurrentToken() + " token");
    }

    protected String _calcName(Class<?> cls) {
        if (cls.isArray()) {
            return this._calcName(cls.getComponentType()) + "[]";
        }
        return cls.getName();
    }

    @Override
    public JsonMappingException instantiationException(Class<?> instClass, Exception e) {
        return JsonMappingException.from(this._parser, "Can not construct instance of " + instClass.getName() + ", problem: " + e.getMessage());
    }

    @Override
    public JsonMappingException weirdStringException(Class<?> instClass, String msg) {
        return JsonMappingException.from(this._parser, "Can not construct instance of " + instClass.getName() + " from String value '" + this._valueDesc() + "': " + msg);
    }

    @Override
    public JsonMappingException weirdNumberException(Class<?> instClass, String msg) {
        return JsonMappingException.from(this._parser, "Can not construct instance of " + instClass.getName() + " from number value (" + this._valueDesc() + "): " + msg);
    }

    @Override
    public JsonMappingException weirdKeyException(Class<?> keyClass, String keyValue, String msg) {
        return JsonMappingException.from(this._parser, "Can not construct Map key of type " + keyClass.getName() + " from String \"" + this._desc(keyValue) + "\": " + msg);
    }

    @Override
    public JsonMappingException unknownFieldException(Object instance, String fieldName) {
        String clsName = this.determineClassName(instance);
        return JsonMappingException.from(this._parser, "Unrecognized field \"" + fieldName + "\" (Class " + clsName + "), not marked as ignorable");
    }

    protected String determineClassName(Object instance) {
        if (instance == null) {
            return "unknown";
        }
        Class<?> cls = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        return cls.getName();
    }

    protected DateFormat getDateFormat() {
        if (this._dateFormat == null) {
            this._dateFormat = (DateFormat)this._config.getDateFormat().clone();
        }
        return this._dateFormat;
    }

    protected String _valueDesc() {
        try {
            return this._desc(this._parser.getText());
        }
        catch (Exception e) {
            return "[N/A]";
        }
    }

    protected String _desc(String desc) {
        if (desc.length() > 500) {
            desc = desc.substring(0, 500) + "]...[" + desc.substring(desc.length() - 500);
        }
        return desc;
    }
}

