/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:build-helper-maven-plugin:1.5", 0);
        this.append(sb, "", 0);
        this.append(sb, "Build Helper Maven Plugin", 0);
        this.append(sb, "This plugin contains various small independent goals to assist with Maven build lifecycle", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 10 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "add-resource".equals(this.goal)) {
            this.append(sb, "build-helper:add-resource", 0);
            this.append(sb, "Add more resource directories to the POM.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "resources", 2);
                this.append(sb, "Additional source directories.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "add-source".equals(this.goal)) {
            this.append(sb, "build-helper:add-source", 0);
            this.append(sb, "Add more source directories to the POM.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "Additional source directories.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "add-test-resource".equals(this.goal)) {
            this.append(sb, "build-helper:add-test-resource", 0);
            this.append(sb, "Add more test resource directories to the POM.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "resources", 2);
                this.append(sb, "Additional source directories.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "add-test-source".equals(this.goal)) {
            this.append(sb, "build-helper:add-test-source", 0);
            this.append(sb, "Add test source directories to the POM.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "Additional test source directories.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "attach-artifact".equals(this.goal)) {
            this.append(sb, "build-helper:attach-artifact", 0);
            this.append(sb, "Attach additional artifacts to be installed and deployed.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "artifacts", 2);
                this.append(sb, "Attach an array of artifacts to the project.", 3);
                this.append(sb, "", 0);
                this.append(sb, "basedir", 2);
                this.append(sb, "This project's base directory.", 3);
                this.append(sb, "", 0);
                this.append(sb, "runOnlyAtExecutionRoot (Default: false)", 2);
                this.append(sb, "This will cause the execution to be run only at the top of a given module tree. That is, run in the project contained in the same folder where the mvn execution was launched.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "build-helper:help", 0);
            this.append(sb, "Display help information on build-helper-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0build-helper:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "maven-version".equals(this.goal)) {
            this.append(sb, "build-helper:maven-version", 0);
            this.append(sb, "Store the maven core version in a property maven.version.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "versionProperty (Default: maven.version)", 2);
                this.append(sb, "The name of the property in which to store the version of maven.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "parse-version".equals(this.goal)) {
            this.append(sb, "build-helper:parse-version", 0);
            this.append(sb, "Parse a version string and set properties containing the component parts of the version. This mojo sets the following properties:\n\u00a0\u00a0[propertyPrefix].majorVersion\n\u00a0\u00a0[propertyPrefix].minorVersion\n\u00a0\u00a0[propertyPrefix].incrementalVersion\n\u00a0\u00a0[propertyPrefix].qualifier\n\u00a0\u00a0[propertyPrefix].buildNumber\nWhere the propertyPrefix is the string set in the mojo parameter. Note that the behaviour of the parsing is determined by org.apache.maven.artifact.versioning.DefaultArtifactVersion An osgi compatible version will also be created and made available through the property:\n\u00a0\u00a0[propertyPrefix].osgiVersion\nThis version is simply the original version string with the first instance of '-' replaced by '.' For example, 1.0.2-beta-1 will be converted to 1.0.2.beta-1", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "propertyPrefix (Default: parsedVersion)", 2);
                this.append(sb, "Prefix string to use for the set of version properties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "versionString (Default: ${project.version})", 2);
                this.append(sb, "The version string to parse.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "remove-project-artifact".equals(this.goal)) {
            this.append(sb, "build-helper:remove-project-artifact", 0);
            this.append(sb, "Remove project's artifacts from local repository. Useful to keep only one copy of large local snapshot, for example: installer, for disk space optimization purpose.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "removeAll (Default: true)", 2);
                this.append(sb, "When true, remove all built artifacts including all versions. When false, remove all built artifacts of this project version.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "reserve-network-port".equals(this.goal)) {
            this.append(sb, "build-helper:reserve-network-port", 0);
            this.append(sb, "Reserve a list of random and not in used network ports and place them in a configurable project properties.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "outputFile", 2);
                this.append(sb, "Output file to write the generated properties to. if not given, they are written to maven project", 3);
                this.append(sb, "", 0);
                this.append(sb, "portNames", 2);
                this.append(sb, "A List to property names to be placed in maven project", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

