/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.util.List;
import java.util.Objects;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.buildhelper.AbstractDefinePropertyMojo;

@Mojo(name="released-version", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class ReleasedVersionMojo
extends AbstractDefinePropertyMojo {
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${localRepository}", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    private List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(defaultValue="releasedVersion")
    private String propertyPrefix;

    private void defineVersionProperty(String name, String value) {
        this.defineProperty(this.propertyPrefix + '.' + name, Objects.toString(value, ""));
    }

    private void defineVersionProperty(String name, int value) {
        this.defineVersionProperty(name, Integer.toString(value));
    }

    public void execute() {
        block6: {
            Artifact artifact = this.artifactFactory.createArtifact(this.getProject().getGroupId(), this.getProject().getArtifactId(), this.getProject().getVersion(), "", "");
            try {
                Object releasedVersion = null;
                List versions = this.artifactMetadataSource.retrieveAvailableVersions(artifact, this.localRepository, this.remoteArtifactRepositories);
                for (ArtifactVersion version : versions) {
                    if (ArtifactUtils.isSnapshot((String)version.toString()) || releasedVersion != null && version.compareTo(releasedVersion) <= 0) continue;
                    releasedVersion = version;
                }
                if (releasedVersion != null) {
                    String releasedVersionValue = releasedVersion.toString();
                    int dashIndex = releasedVersionValue.indexOf(45);
                    if (dashIndex >= 0) {
                        releasedVersionValue = releasedVersionValue.substring(0, dashIndex);
                    }
                    this.defineVersionProperty("version", releasedVersionValue);
                    this.defineVersionProperty("majorVersion", releasedVersion.getMajorVersion());
                    this.defineVersionProperty("minorVersion", releasedVersion.getMinorVersion());
                    this.defineVersionProperty("incrementalVersion", releasedVersion.getIncrementalVersion());
                    this.defineVersionProperty("buildNumber", releasedVersion.getBuildNumber());
                    this.defineVersionProperty("qualifier", releasedVersion.getQualifier());
                } else {
                    this.getLog().debug((CharSequence)"No released version found.");
                }
            }
            catch (ArtifactMetadataRetrievalException e) {
                if (!this.getLog().isWarnEnabled()) break block6;
                this.getLog().warn((CharSequence)"Failed to retrieve artifacts metadata, cannot resolve the released version");
            }
        }
    }
}

