/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura;

import java.io.File;
import java.text.NumberFormat;
import java.util.Date;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.util.Header;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.cobertura.AbstractCoberturaMojo;

public class CoberturaDatafileDumpMojo
extends AbstractCoberturaMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipMojo()) {
            return;
        }
        if (!this.getDataFile().exists()) {
            throw new MojoExecutionException("Unable to dump nonexistent dataFile [" + this.getDataFile() + "]");
        }
        ProjectData projectData = CoverageDataFileHandler.loadCoverageData((File)this.getDataFile());
        NumberFormat percentage = NumberFormat.getPercentInstance();
        NumberFormat integer = NumberFormat.getIntegerInstance();
        this.println("<?xml version=\"1.0\"?>");
        this.printProject(projectData, percentage, integer);
        for (PackageData packageData : projectData.getPackages()) {
            this.printPackage(percentage, integer, packageData);
        }
        this.println("</coverage>");
    }

    private void printProject(ProjectData projectData, NumberFormat percentage, NumberFormat integer) {
        this.println("<coverage line-rate=\"" + percentage.format(projectData.getLineCoverageRate()) + "\" branch-rate=\"" + percentage.format(projectData.getBranchCoverageRate()) + "\" lines-covered=\"" + integer.format(projectData.getNumberOfCoveredLines()) + "\" lines-valid=\"" + integer.format(projectData.getNumberOfValidLines()) + "\" branches-covered=\"" + integer.format(projectData.getNumberOfCoveredBranches()) + "\" branches-valid=\"" + integer.format(projectData.getNumberOfValidBranches()) + "\" version=\"" + Header.version() + "\" timestamp=\"" + new Date().getTime() + "\">");
    }

    private void printPackage(NumberFormat percentage, NumberFormat integer, PackageData packageData) {
        this.println("<package name=\"" + packageData.getName() + "\" line-rate=\"" + percentage.format(packageData.getLineCoverageRate()) + "\" branch-rate=\"" + percentage.format(packageData.getBranchCoverageRate()) + "\" lines-covered=\"" + integer.format(packageData.getNumberOfCoveredLines()) + "\" lines-valid=\"" + integer.format(packageData.getNumberOfValidLines()) + "\" branches-covered=\"" + integer.format(packageData.getNumberOfCoveredBranches()) + "\" branches-valid=\"" + integer.format(packageData.getNumberOfValidBranches()) + "\" />");
    }

    private void println(String msg) {
        this.getLog().info((CharSequence)msg);
    }
}

