/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.File;
import java.util.List;
import org.apache.maven.toolchain.DefaultToolchain;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.Os;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathsToolchain
extends DefaultToolchain {
    private List<String> paths;

    public PathsToolchain(ToolchainModel model, Logger logger) {
        super(model, "paths", logger);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public String toString() {
        return "Paths" + this.getPaths();
    }

    public String findTool(String toolName) {
        for (String path : this.paths) {
            File tool = PathsToolchain.findTool(toolName, new File(path));
            if (tool == null) continue;
            return tool.getAbsolutePath();
        }
        return null;
    }

    private static File findTool(String toolName, File folder) {
        File tool = new File(folder, toolName + (Os.isFamily((String)"windows") && !toolName.contains(".") ? ".exe" : ""));
        return tool.exists() ? tool : null;
    }
}

