/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="revert", requiresProject=true, requiresDirectInvocation=true)
public class RevertMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File outFile = this.project.getFile();
        File backupFile = new File(outFile.getParentFile(), outFile.getName() + ".versionsBackup");
        if (backupFile.exists()) {
            this.getLog().info((CharSequence)("Restoring " + outFile + " from " + backupFile));
            try {
                FileUtils.copyFile((File)backupFile, (File)outFile);
                FileUtils.forceDelete((File)backupFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
    }
}

