/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.ordering;

import java.util.LinkedList;
import org.apache.maven.artifact.versioning.ArtifactVersion;

public class MajorMinorIncrementalFilter {
    private boolean allowMajorUpdates;
    private boolean allowMinorUpdates;
    private boolean allowIncrementalUpdates;

    public MajorMinorIncrementalFilter(boolean allowMajorUpdates, boolean allowMinorUpdates, boolean allowIncrementalUpdates) {
        this.allowMajorUpdates = allowMajorUpdates;
        this.allowMinorUpdates = allowMinorUpdates;
        this.allowIncrementalUpdates = allowIncrementalUpdates;
    }

    public ArtifactVersion[] filter(ArtifactVersion selectedVersion, ArtifactVersion[] newerVersions) {
        LinkedList<ArtifactVersion> versionsToUse = new LinkedList<ArtifactVersion>();
        for (ArtifactVersion artifactVersion : newerVersions) {
            if (artifactVersion.getMajorVersion() != selectedVersion.getMajorVersion()) {
                if (!this.allowMajorUpdates || versionsToUse.contains(artifactVersion)) continue;
                versionsToUse.add(artifactVersion);
                continue;
            }
            if (artifactVersion.getMinorVersion() != selectedVersion.getMinorVersion()) {
                if (!this.allowMinorUpdates || versionsToUse.contains(artifactVersion)) continue;
                versionsToUse.add(artifactVersion);
                continue;
            }
            if (artifactVersion.getIncrementalVersion() != selectedVersion.getIncrementalVersion()) {
                if (!this.allowIncrementalUpdates || versionsToUse.contains(artifactVersion)) continue;
                versionsToUse.add(artifactVersion);
                continue;
            }
            if (!this.allowMajorUpdates || !this.allowMinorUpdates || !this.allowIncrementalUpdates || versionsToUse.contains(artifactVersion)) continue;
            versionsToUse.add(artifactVersion);
        }
        return versionsToUse.toArray(new ArtifactVersion[versionsToUse.size()]);
    }
}

