/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.plexus.archiver.ArchiveFinalizer;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FinalizerEnabled;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.util.ArchiveEntryUtils;
import org.codehaus.plexus.components.io.attributes.SymlinkUtils;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractUnArchiver
extends AbstractLogEnabled
implements UnArchiver,
FinalizerEnabled {
    private File destDirectory;
    private File destFile;
    private File sourceFile;
    private boolean overwrite = true;
    private FileMapper[] fileMappers;
    private List finalizers;
    private FileSelector[] fileSelectors;
    private boolean useJvmChmod = true;
    private boolean ignorePermissions = false;

    public AbstractUnArchiver() {
    }

    public AbstractUnArchiver(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Override
    public File getDestDirectory() {
        return this.destDirectory;
    }

    @Override
    public void setDestDirectory(File destDirectory) {
        this.destDirectory = destDirectory;
    }

    @Override
    public File getDestFile() {
        return this.destFile;
    }

    @Override
    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    @Override
    public File getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void setSourceFile(File sourceFile) {
        this.sourceFile = sourceFile;
    }

    @Override
    public boolean isOverwrite() {
        return this.overwrite;
    }

    @Override
    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    @Override
    public FileMapper[] getFileMappers() {
        return this.fileMappers;
    }

    @Override
    public void setFileMappers(FileMapper[] fileMappers) {
        this.fileMappers = fileMappers;
    }

    @Override
    public final void extract() throws ArchiverException {
        this.validate();
        this.execute();
        this.runArchiveFinalizers();
    }

    @Override
    public final void extract(String path, File outputDirectory) throws ArchiverException {
        this.validate(path, outputDirectory);
        this.execute(path, outputDirectory);
        this.runArchiveFinalizers();
    }

    @Override
    public void addArchiveFinalizer(ArchiveFinalizer finalizer) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList();
        }
        this.finalizers.add(finalizer);
    }

    public void setArchiveFinalizers(List archiveFinalizers) {
        this.finalizers = archiveFinalizers;
    }

    private void runArchiveFinalizers() throws ArchiverException {
        if (this.finalizers != null) {
            for (Object finalizer1 : this.finalizers) {
                ArchiveFinalizer finalizer = (ArchiveFinalizer)finalizer1;
                finalizer.finalizeArchiveExtraction(this);
            }
        }
    }

    protected void validate(String path, File outputDirectory) {
    }

    protected void validate() throws ArchiverException {
        if (this.sourceFile == null) {
            throw new ArchiverException("The source file isn't defined.");
        }
        if (this.sourceFile.isDirectory()) {
            throw new ArchiverException("The source must not be a directory.");
        }
        if (!this.sourceFile.exists()) {
            throw new ArchiverException("The source file " + this.sourceFile + " doesn't exist.");
        }
        if (this.destDirectory == null && this.destFile == null) {
            throw new ArchiverException("The destination isn't defined.");
        }
        if (this.destDirectory != null && this.destFile != null) {
            throw new ArchiverException("You must choose between a destination directory and a destination file.");
        }
        if (this.destDirectory != null && !this.destDirectory.isDirectory()) {
            this.destFile = this.destDirectory;
            this.destDirectory = null;
        }
        if (this.destFile != null && this.destFile.isDirectory()) {
            this.destDirectory = this.destFile;
            this.destFile = null;
        }
    }

    @Override
    public void setFileSelectors(FileSelector[] fileSelectors) {
        this.fileSelectors = fileSelectors;
    }

    @Override
    public FileSelector[] getFileSelectors() {
        return this.fileSelectors;
    }

    protected boolean isSelected(String fileName, PlexusIoResource fileInfo) throws ArchiverException {
        if (this.fileSelectors != null) {
            for (FileSelector fileSelector : this.fileSelectors) {
                try {
                    if (fileSelector.isSelected((FileInfo)fileInfo)) continue;
                    return false;
                }
                catch (IOException e) {
                    throw new ArchiverException("Failed to check, whether " + fileInfo.getName() + " is selected: " + e.getMessage(), e);
                }
            }
        }
        return true;
    }

    protected abstract void execute() throws ArchiverException;

    protected abstract void execute(String var1, File var2) throws ArchiverException;

    @Override
    public boolean isUseJvmChmod() {
        return this.useJvmChmod;
    }

    @Override
    public void setUseJvmChmod(boolean useJvmChmod) {
        this.useJvmChmod = useJvmChmod;
    }

    @Override
    public boolean isIgnorePermissions() {
        return this.ignorePermissions;
    }

    @Override
    public void setIgnorePermissions(boolean ignorePermissions) {
        this.ignorePermissions = ignorePermissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void extractFile(File srcF, File dir, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory, Integer mode, String symlinkDestination, FileMapper[] fileMappers) throws IOException, ArchiverException {
        if (fileMappers != null) {
            for (FileMapper fileMapper : fileMappers) {
                entryName = fileMapper.getMappedFileName(entryName);
            }
        }
        File f = FileUtils.resolveFile((File)dir, (String)entryName);
        String canonicalDirPath = dir.getCanonicalPath();
        String canonicalDestPath = f.getCanonicalPath();
        if (!canonicalDestPath.startsWith(canonicalDirPath)) {
            throw new ArchiverException("Entry is outside of the target directory (" + entryName + ")");
        }
        try {
            if (!this.isOverwrite() && f.exists() && f.lastModified() >= entryDate.getTime()) {
                return;
            }
            File dirF = f.getParentFile();
            if (dirF != null) {
                dirF.mkdirs();
            }
            if (!StringUtils.isEmpty((String)symlinkDestination)) {
                SymlinkUtils.createSymbolicLink((File)f, (File)new File(symlinkDestination));
            } else if (isDirectory) {
                f.mkdirs();
            } else {
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(f);
                    IOUtil.copy((InputStream)compressedInputStream, (OutputStream)out);
                    ((OutputStream)out).close();
                    out = null;
                }
                catch (Throwable throwable) {
                    IOUtil.close(out);
                    throw throwable;
                }
                IOUtil.close((OutputStream)out);
            }
            f.setLastModified(entryDate.getTime());
            if (this.isIgnorePermissions()) return;
            if (mode == null) return;
            if (isDirectory) return;
            ArchiveEntryUtils.chmod(f, mode);
            return;
        }
        catch (FileNotFoundException ex) {
            this.getLogger().warn("Unable to expand to file " + f.getPath());
        }
    }
}

