/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.manager;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassRealmAdapter;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.factory.ComponentFactory;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.factory.UndefinedComponentFactoryException;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.PhaseExecutionException;

public abstract class AbstractComponentManager
implements ComponentManager,
Cloneable {
    protected MutablePlexusContainer container;
    protected ComponentDescriptor componentDescriptor;
    private LifecycleHandler lifecycleHandler;
    protected Map componentContextRealms = new HashMap();
    private int connections;
    private String id = null;

    public ComponentManager copy() {
        try {
            ComponentManager componentManager = (ComponentManager)this.clone();
            return componentManager;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ComponentDescriptor getComponentDescriptor() {
        return this.componentDescriptor;
    }

    public String getId() {
        return this.id;
    }

    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    protected void incrementConnectionCount() {
        ++this.connections;
    }

    protected void decrementConnectionCount() {
        --this.connections;
    }

    protected boolean connected() {
        return this.connections > 0;
    }

    public int getConnections() {
        return this.connections;
    }

    public void setup(MutablePlexusContainer container, LifecycleHandler lifecycleHandler, ComponentDescriptor componentDescriptor) {
        this.container = container;
        this.lifecycleHandler = lifecycleHandler;
        this.componentDescriptor = componentDescriptor;
    }

    public void initialize() {
    }

    protected Object createComponentInstance(org.codehaus.plexus.classworlds.realm.ClassRealm realm) throws ComponentInstantiationException, ComponentLifecycleException {
        Object component = this.createComponentInstance(this.componentDescriptor, realm);
        this.componentContextRealms.put(component, realm);
        this.startComponentLifecycle(component, realm);
        return component;
    }

    protected void startComponentLifecycle(Object component, org.codehaus.plexus.classworlds.realm.ClassRealm realm) throws ComponentLifecycleException {
        try {
            this.getLifecycleHandler().start(component, this, realm);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error starting component", (Throwable)e);
        }
    }

    public void suspend(Object component) throws ComponentLifecycleException {
        try {
            this.getLifecycleHandler().suspend(component, this);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error suspending component", (Throwable)e);
        }
    }

    public void resume(Object component) throws ComponentLifecycleException {
        try {
            this.getLifecycleHandler().resume(component, this);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error suspending component", (Throwable)e);
        }
    }

    protected void endComponentLifecycle(Object component) throws ComponentLifecycleException {
        org.codehaus.plexus.classworlds.realm.ClassRealm contextRealm = (org.codehaus.plexus.classworlds.realm.ClassRealm)this.componentContextRealms.get(component);
        if (contextRealm == null) {
            contextRealm = this.container.getLookupRealm(component);
        }
        try {
            this.getLifecycleHandler().end(component, this, contextRealm);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error ending component lifecycle", (Throwable)e);
        }
    }

    public MutablePlexusContainer getContainer() {
        return this.container;
    }

    public Logger getLogger() {
        return this.container.getLogger();
    }

    protected Object createComponentInstance(ComponentDescriptor componentDescriptor, org.codehaus.plexus.classworlds.realm.ClassRealm realm) throws ComponentInstantiationException, ComponentLifecycleException {
        Object component;
        String componentFactoryId = componentDescriptor.getComponentFactory();
        try {
            ComponentFactory componentFactory = componentFactoryId != null ? this.container.getComponentFactoryManager().findComponentFactory(componentFactoryId) : this.container.getComponentFactoryManager().getDefaultComponentFactory();
            org.codehaus.plexus.classworlds.realm.ClassRealm componentRealm = realm == null ? this.container.getComponentRealm(componentDescriptor.getRealmId()) : realm;
            try {
                component = componentFactory.newInstance(componentDescriptor, componentRealm, this.container);
            }
            catch (AbstractMethodError e) {
                ClassRealmAdapter cr = ClassRealmAdapter.getInstance((org.codehaus.plexus.classworlds.realm.ClassRealm)componentRealm);
                try {
                    Method method = componentFactory.getClass().getMethod("newInstance", ComponentDescriptor.class, ClassRealm.class, PlexusContainer.class);
                    component = method.invoke((Object)componentFactory, componentDescriptor, cr, this.container);
                }
                catch (Exception mnfe) {
                    throw new ComponentInstantiationException("Unable to create component as factory '" + componentFactoryId + "' could not be found", e);
                }
            }
        }
        catch (UndefinedComponentFactoryException e) {
            throw new ComponentInstantiationException("Unable to create component as factory '" + componentFactoryId + "' could not be found", e);
        }
        return component;
    }

    public Object getComponent() throws ComponentInstantiationException, ComponentLifecycleException {
        return this.getComponent(this.container.getLookupRealm());
    }
}

