/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.fileselectors;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.SelectorUtils;

public class IncludeExcludeFileSelector
implements FileSelector {
    public static final String ROLE_HINT = "standard";
    private static final String[] ALL_INCLUDES = new String[]{IncludeExcludeFileSelector.getCanonicalName("**/*")};
    private static final String[] ZERO_EXCLUDES = new String[0];
    private boolean isCaseSensitive = true;
    private boolean useDefaultExcludes = true;
    private String[] includes;
    private String[] excludes;
    private String[] computedIncludes = ALL_INCLUDES;
    private String[] computedExcludes = ZERO_EXCLUDES;

    protected boolean isExcluded(String name) {
        for (int i = 0; i < this.computedExcludes.length; ++i) {
            if (!this.matchPath(this.computedExcludes[i], name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
        if (includes == null) {
            this.computedIncludes = ALL_INCLUDES;
        } else {
            this.computedIncludes = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                String pattern;
                this.computedIncludes[i] = pattern = this.asPattern(includes[i]);
            }
        }
    }

    private static String getCanonicalName(String pName) {
        return pName.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }

    private String asPattern(String pPattern) {
        String pattern = IncludeExcludeFileSelector.getCanonicalName(pPattern.trim());
        if (pattern.endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setExcludes(String[] excludes) {
        String[] defaultExcludes;
        this.excludes = null;
        String[] stringArray = defaultExcludes = this.useDefaultExcludes ? FileUtils.getDefaultExcludes() : ZERO_EXCLUDES;
        if (excludes == null) {
            this.computedExcludes = defaultExcludes;
        } else {
            this.computedExcludes = new String[excludes.length + defaultExcludes.length];
            this.excludes = new String[excludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                this.computedExcludes[i] = this.asPattern(excludes[i]);
            }
            if (defaultExcludes.length > 0) {
                System.arraycopy(defaultExcludes, 0, this.computedExcludes, excludes.length, defaultExcludes.length);
            }
        }
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    protected boolean matchPath(String pattern, String name, boolean isCaseSensitive) {
        return SelectorUtils.matchPath((String)pattern, (String)name, (boolean)isCaseSensitive);
    }

    protected boolean isIncluded(String name) {
        for (int i = 0; i < this.computedIncludes.length; ++i) {
            if (!this.matchPath(this.computedIncludes[i], name, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelected(FileInfo pFileInfo) throws IOException {
        String name = IncludeExcludeFileSelector.getCanonicalName(pFileInfo.getName());
        return this.isIncluded(name) && !this.isExcluded(name);
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    public boolean isUseDefaultExcludes() {
        return this.useDefaultExcludes;
    }

    public void setUseDefaultExcludes(boolean pUseDefaultExcludes) {
        this.useDefaultExcludes = pUseDefaultExcludes;
        this.setExcludes(this.excludes);
    }
}

