/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources.proxy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributeUtils;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResource;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIOResourceCollectionWithAttributes;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;
import org.codehaus.plexus.components.io.resources.proxy.PlexusIoProxyResourceWithAttributes;

public class PlexusIoProxyResourceCollection
extends AbstractPlexusIoResourceCollection
implements PlexusIOResourceCollectionWithAttributes {
    private PlexusIoResourceCollection src;
    private SimpleResourceAttributes defaultFileAttributes;
    private SimpleResourceAttributes defaultDirAttributes;
    private PlexusIoResourceAttributes overrideFileAttributes;
    private PlexusIoResourceAttributes overrideDirAttributes;

    public void setSrc(PlexusIoResourceCollection src) {
        this.src = src;
    }

    public PlexusIoResourceCollection getSrc() {
        return this.src;
    }

    protected FileSelector getDefaultFileSelector() {
        IncludeExcludeFileSelector fileSelector = new IncludeExcludeFileSelector();
        fileSelector.setIncludes(this.getIncludes());
        fileSelector.setExcludes(this.getExcludes());
        fileSelector.setCaseSensitive(this.isCaseSensitive());
        fileSelector.setUseDefaultExcludes(this.isUsingDefaultExcludes());
        return fileSelector;
    }

    public Iterator getResources() throws IOException {
        ArrayList<PlexusIoResource> result = new ArrayList<PlexusIoResource>();
        FileSelector fileSelector = this.getDefaultFileSelector();
        String prefix = this.getPrefix();
        if (prefix != null && prefix.length() == 0) {
            prefix = null;
        }
        Iterator iter = this.getSrc().getResources();
        while (iter.hasNext()) {
            PlexusIoResource plexusIoResource = (PlexusIoResource)iter.next();
            PlexusIoResourceAttributes attrs = null;
            if (plexusIoResource instanceof PlexusIoResourceWithAttributes) {
                attrs = ((PlexusIoResourceWithAttributes)plexusIoResource).getAttributes();
            }
            attrs = plexusIoResource.isDirectory() ? PlexusIoResourceAttributeUtils.mergeAttributes(this.overrideDirAttributes, attrs, this.defaultDirAttributes) : PlexusIoResourceAttributeUtils.mergeAttributes(this.overrideFileAttributes, attrs, this.defaultFileAttributes);
            if (!fileSelector.isSelected(plexusIoResource) || !this.isSelected(plexusIoResource) || plexusIoResource.isDirectory() && !this.isIncludingEmptyDirectories()) continue;
            if (prefix != null) {
                String name = plexusIoResource.getName();
                plexusIoResource = plexusIoResource instanceof PlexusIoResourceWithAttributes ? new PlexusIoProxyResourceWithAttributes(plexusIoResource, attrs) : new PlexusIoProxyResourceWithAttributes(plexusIoResource, attrs);
                ((AbstractPlexusIoResource)plexusIoResource).setName(prefix + name);
            }
            result.add(plexusIoResource);
        }
        return result.iterator();
    }

    public String getName(PlexusIoResource resource) throws IOException {
        String name = resource.getName();
        FileMapper[] mappers = this.getFileMappers();
        if (mappers != null) {
            for (int i = 0; i < mappers.length; ++i) {
                name = mappers[i].getMappedFileName(name);
            }
        }
        return name;
    }

    public long getLastModified() throws IOException {
        return this.src.getLastModified();
    }

    public void setDefaultAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.defaultFileAttributes = new SimpleResourceAttributes(uid, userName, gid, groupName, fileMode);
        this.defaultFileAttributes.setOctalMode(fileMode);
        this.defaultDirAttributes = new SimpleResourceAttributes(uid, userName, gid, groupName, dirMode);
        this.defaultDirAttributes.setOctalMode(dirMode);
    }

    public void setOverrideAttributes(int uid, String userName, int gid, String groupName, int fileMode, int dirMode) {
        this.overrideFileAttributes = new SimpleResourceAttributes(uid, userName, gid, groupName, fileMode);
        this.overrideDirAttributes = new SimpleResourceAttributes(uid, userName, gid, groupName, dirMode);
    }
}

