/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoArchiveResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoURLResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlexusIoZipFileResourceCollection
extends AbstractPlexusIoArchiveResourceCollection {
    public static final String ROLE_HINT = "zipFile";
    public static final String JAR_ROLE_HINT = "jarFile";

    @Override
    protected Iterator<PlexusIoResource> getEntries() throws IOException {
        File f = this.getFile();
        if (f == null) {
            throw new IOException("The zip file has not been set.");
        }
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{f.toURI().toURL()}, null){

            public URL getResource(String name) {
                return this.findResource(name);
            }
        };
        URL url = new URL("jar:" + f.toURI().toURL() + "!/");
        ZipFile zipFile = new ZipFile(f);
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        return new ZipFileResourceIterator(en, url, zipFile, urlClassLoader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZipFileResourceIterator
    implements Iterator<PlexusIoResource>,
    Closeable {
        private final Enumeration en;
        private final URL url;
        private final ZipFile zipFile;
        private final URLClassLoader urlClassLoader;

        public ZipFileResourceIterator(Enumeration en, URL url, ZipFile zipFile, URLClassLoader urlClassLoader) {
            this.en = en;
            this.url = url;
            this.zipFile = zipFile;
            this.urlClassLoader = urlClassLoader;
        }

        @Override
        public boolean hasNext() {
            return this.en.hasMoreElements();
        }

        @Override
        public PlexusIoResource next() {
            ZipEntry entry = (ZipEntry)this.en.nextElement();
            long l = entry.getTime();
            long lastModified = l == -1L ? 0L : l;
            boolean dir = entry.isDirectory();
            long size = dir ? -1L : entry.getSize();
            return new PlexusIoURLResource(entry.getName(), lastModified, size, !dir, dir, true){

                public URL getURL() throws IOException {
                    String spec = this.getName();
                    if (spec.startsWith("/")) {
                        spec = "./" + spec;
                        return new URL(ZipFileResourceIterator.this.url, spec);
                    }
                    return ZipFileResourceIterator.this.urlClassLoader.getResource(spec);
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing isn't implemented.");
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }
    }
}

