/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.languages.java.jpms;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.codehaus.plexus.languages.java.jpms.AbstractBinaryModuleInfoParser;
import org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ModuleVisitor;

class AsmModuleInfoParser
extends AbstractBinaryModuleInfoParser {
    AsmModuleInfoParser() {
    }

    @Override
    JavaModuleDescriptor parse(InputStream in) throws IOException {
        final JavaModuleDescriptorWrapper wrapper = new JavaModuleDescriptorWrapper();
        ClassReader reader = new ClassReader(in);
        reader.accept(new ClassVisitor(589824){

            public ModuleVisitor visitModule(String name, int arg1, String arg2) {
                wrapper.builder = JavaModuleDescriptor.newModule(name);
                return new ModuleVisitor(589824){

                    public void visitRequire(String module, int access, String version) {
                        if ((access & 0x40) != 0) {
                            wrapper.builder.requires(Collections.singleton(JavaModuleDescriptor.JavaRequires.JavaModifier.STATIC), module);
                        } else {
                            wrapper.builder.requires(module);
                        }
                    }

                    public void visitExport(String pn, int ms, String ... targets) {
                        if (targets == null || targets.length == 0) {
                            wrapper.builder.exports(pn.replace('/', '.'));
                        } else {
                            wrapper.builder.exports(pn.replace('/', '.'), new HashSet<String>(Arrays.asList(targets)));
                        }
                    }

                    public void visitUse(String service) {
                        wrapper.builder.uses(service.replace('/', '.'));
                    }

                    public void visitProvide(String service, String ... providers) {
                        ArrayList<String> renamedProvides = new ArrayList<String>(providers.length);
                        for (String provider : providers) {
                            renamedProvides.add(provider.replace('/', '.'));
                        }
                        wrapper.builder.provides(service.replace('/', '.'), renamedProvides);
                    }
                };
            }
        }, 0);
        return wrapper.builder.build();
    }

    private static class JavaModuleDescriptorWrapper {
        private JavaModuleDescriptor.Builder builder;

        private JavaModuleDescriptorWrapper() {
        }
    }
}

