/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.connection;

import java.util.HashMap;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.Transaction;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ConnectionFactory;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.util.StringUtils;

public abstract class AbstractConnectionFactory
implements ConnectionFactory {
    protected StoreManager storeMgr;
    protected Map options = null;
    protected String resourceType;

    public AbstractConnectionFactory(StoreManager storeMgr, String resourceType) {
        this.storeMgr = storeMgr;
        this.resourceType = resourceType;
        if (resourceType != null) {
            if (resourceType.equals("tx")) {
                String configuredResourceTypeProperty = storeMgr.getStringProperty("datanucleus.connection.resourceType");
                if (configuredResourceTypeProperty != null) {
                    if (this.options == null) {
                        this.options = new HashMap();
                    }
                    this.options.put("resource-type", configuredResourceTypeProperty);
                }
            } else {
                String configuredResourceTypeProperty = storeMgr.getStringProperty("datanucleus.connection2.resourceType");
                if (configuredResourceTypeProperty != null) {
                    if (this.options == null) {
                        this.options = new HashMap();
                    }
                    this.options.put("resource-type", configuredResourceTypeProperty);
                }
            }
        }
    }

    @Override
    public ManagedConnection getConnection(ExecutionContext ec, Transaction txn, Map options) {
        HashMap addedOptions = new HashMap();
        if (options != null) {
            addedOptions.putAll(options);
        }
        if (this.options != null) {
            addedOptions.putAll(this.options);
        }
        ManagedConnection mconn = this.storeMgr.getConnectionManager().allocateConnection(this, ec, txn, addedOptions);
        ((AbstractManagedConnection)mconn).incrementUseCount();
        return mconn;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "ConnectionFactory:" + this.resourceType + "[" + StringUtils.toJVMIDString(this) + "]";
    }
}

