/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.log4jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.digitalforge.log4jdbc.JdbcSpy;
import org.digitalforge.log4jdbc.LoggingConnection;
import org.digitalforge.log4jdbc.LoggingPreparedStatement;
import org.digitalforge.log4jdbc.SpyLogDelegator;
import org.digitalforge.log4jdbc.SpyLogFactory;
import org.digitalforge.log4jdbc.util.Utilities;

public class LoggingCallableStatement<S extends CallableStatement>
extends LoggingPreparedStatement<CallableStatement>
implements CallableStatement {
    private static final SpyLogDelegator log = SpyLogFactory.getSpyLogDelegator();

    @Override
    protected void reportAllReturns(String methodCall, String msg) {
        log.methodReturned(this, methodCall, msg);
    }

    public LoggingCallableStatement(String sql, LoggingConnection connection, S delegate) {
        super(sql, connection, delegate);
    }

    @Override
    public String getClassType() {
        return "CallableStatement";
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        String methodCall = "getDate(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getDate(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        String methodCall = "getDate(" + parameterIndex + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getDate(parameterIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        String methodCall = "getRef(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getRef(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        String methodCall = "getTime(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getTime(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        String methodCall = "setTime(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setTime(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        String methodCall = "getBlob(" + i + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getBlob(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        String methodCall = "getClob(" + i + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getClob(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Array getArray(int i) throws SQLException {
        String methodCall = "getArray(" + i + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getArray(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        String methodCall = "getBytes(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getBytes(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        String methodCall = "getDouble(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getDouble(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        String methodCall = "getInt(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getInt(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        String methodCall = "wasNull()";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).wasNull());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        String methodCall = "getTime(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getTime(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        String methodCall = "getTime(" + parameterIndex + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getTime(parameterIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        String methodCall = "getTimestamp(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getTimestamp(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        String methodCall = "setTimestamp(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setTimestamp(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        String methodCall = "getString(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getString(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterIndex + ", " + sqlType + ")";
        this.argTraceSet(parameterIndex, null, "<OUT>");
        try {
            ((CallableStatement)this.delegate).registerOutParameter(parameterIndex, sqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterIndex + ", " + sqlType + ", " + scale + ")";
        this.argTraceSet(parameterIndex, null, "<OUT>");
        try {
            ((CallableStatement)this.delegate).registerOutParameter(parameterIndex, sqlType, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        String methodCall = "registerOutParameter(" + paramIndex + ", " + sqlType + ", " + typeName + ")";
        this.argTraceSet(paramIndex, null, "<OUT>");
        try {
            ((CallableStatement)this.delegate).registerOutParameter(paramIndex, sqlType, typeName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        String methodCall = "getByte(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getByte(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        String methodCall = "getDouble(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getDouble(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        String methodCall = "getFloat(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getFloat(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        String methodCall = "getInt(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getInt(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        String methodCall = "getLong(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getLong(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        String methodCall = "getShort(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getShort(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        String methodCall = "getBoolean(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getBoolean(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        String methodCall = "getBytes(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getBytes(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        String methodCall = "setByte(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setByte(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        String methodCall = "setDouble(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setDouble(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        String methodCall = "setFloat(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setFloat(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterName + ", " + sqlType + ")";
        try {
            ((CallableStatement)this.delegate).registerOutParameter(parameterName, sqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        String methodCall = "setInt(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setInt(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        String methodCall = "setNull(" + parameterName + ", " + sqlType + ")";
        try {
            ((CallableStatement)this.delegate).setNull(parameterName, sqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterName + ", " + sqlType + ", " + scale + ")";
        try {
            ((CallableStatement)this.delegate).registerOutParameter(parameterName, sqlType, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        String methodCall = "setLong(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setLong(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        String methodCall = "setShort(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setShort(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        String methodCall = "setBoolean(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setBoolean(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        String argVal = x.length <= 32 ? "0x" + Utilities.hex(x) : "<byte[" + x.length + "]>";
        String methodCall = "setBytes(" + parameterName + ", " + argVal + ")";
        try {
            ((CallableStatement)this.delegate).setBytes(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        String methodCall = "getBoolean(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getBoolean(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        String methodCall = "getTimestamp(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getTimestamp(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        String methodCall = "setAsciiStream(" + parameterName + ", " + x + ", " + length + ")";
        try {
            ((CallableStatement)this.delegate).setAsciiStream(parameterName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        String methodCall = "setBinaryStream(" + parameterName + ", " + x + ", " + length + ")";
        try {
            ((CallableStatement)this.delegate).setBinaryStream(parameterName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        String methodCall = "setCharacterStream(" + parameterName + ", " + reader + ", " + length + ")";
        try {
            ((CallableStatement)this.delegate).setCharacterStream(parameterName, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        String methodCall = "getObject(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getObject(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        String methodCall = "setObject(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setObject(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        String methodCall = "setObject(" + parameterName + ", " + x + ", " + targetSqlType + ")";
        try {
            ((CallableStatement)this.delegate).setObject(parameterName, x, targetSqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        String methodCall = "setObject(" + parameterName + ", " + x + ", " + targetSqlType + ", " + scale + ")";
        try {
            ((CallableStatement)this.delegate).setObject(parameterName, x, targetSqlType, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        String methodCall = "getTimestamp(" + parameterIndex + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getTimestamp(parameterIndex, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        String methodCall = "getDate(" + parameterName + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getDate(parameterName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        String methodCall = "getTime(" + parameterName + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getTime(parameterName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        String methodCall = "getTimestamp(" + parameterName + ", " + cal + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getTimestamp(parameterName, cal));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        String methodCall = "setDate(" + parameterName + ", " + x + ", " + cal + ")";
        try {
            ((CallableStatement)this.delegate).setDate(parameterName, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        String methodCall = "setTime(" + parameterName + ", " + x + ", " + cal + ")";
        try {
            ((CallableStatement)this.delegate).setTime(parameterName, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        String methodCall = "setTimestamp(" + parameterName + ", " + x + ", " + cal + ")";
        try {
            ((CallableStatement)this.delegate).setTimestamp(parameterName, x, cal);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        String methodCall = "getShort(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getShort(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        String methodCall = "getLong(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getLong(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        String methodCall = "getFloat(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getFloat(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        String methodCall = "getRef(" + i + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getRef(i));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        String methodCall = "getBigDecimal(" + parameterIndex + ", " + scale + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getBigDecimal(parameterIndex, scale));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        String methodCall = "getURL(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getURL(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        String methodCall = "getBigDecimal(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getBigDecimal(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        String methodCall = "getByte(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getByte(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        String methodCall = "getObject(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getObject(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Object getObject(int i, Map map) throws SQLException {
        String methodCall = "getObject(" + i + ", " + map + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getObject(i, map));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        String methodCall = "getString(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getString(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterName + ", " + sqlType + ", " + typeName + ")";
        try {
            ((CallableStatement)this.delegate).registerOutParameter(parameterName, sqlType, typeName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        String methodCall = "setNull(" + parameterName + ", " + sqlType + ", " + typeName + ")";
        try {
            ((CallableStatement)this.delegate).setNull(parameterName, sqlType, typeName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        String methodCall = "setString(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setString(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        String methodCall = "getBigDecimal(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getBigDecimal(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        String methodCall = "getObject(" + parameterName + ", " + map + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getObject(parameterName, map));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        String methodCall = "setBigDecimal(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setBigDecimal(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        String methodCall = "getURL(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getURL(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        String methodCall = "getRowId(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getRowId(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        String methodCall = "getRowId(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getRowId(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        String methodCall = "setRowId(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setRowId(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        String methodCall = "setNString(" + parameterName + ", " + value + ")";
        try {
            ((CallableStatement)this.delegate).setNString(parameterName, value);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        String methodCall = "setNCharacterStream(" + parameterName + ", " + reader + ", " + length + ")";
        try {
            ((CallableStatement)this.delegate).setNCharacterStream(parameterName, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        String methodCall = "setNClob(" + parameterName + ", " + value + ")";
        try {
            ((CallableStatement)this.delegate).setNClob(parameterName, value);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        String methodCall = "setClob(" + parameterName + ", " + reader + ", " + length + ")";
        try {
            ((CallableStatement)this.delegate).setClob(parameterName, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        String methodCall = "setBlob(" + parameterName + ", " + inputStream + ", " + length + ")";
        try {
            ((CallableStatement)this.delegate).setBlob(parameterName, inputStream, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        String methodCall = "setNClob(" + parameterName + ", " + reader + ", " + length + ")";
        try {
            ((CallableStatement)this.delegate).setNClob(parameterName, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        String methodCall = "getNClob(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getNClob(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        String methodCall = "getNClob(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getNClob(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        String methodCall = "setSQLXML(" + parameterName + ", " + xmlObject + ")";
        try {
            ((CallableStatement)this.delegate).setSQLXML(parameterName, xmlObject);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        String methodCall = "getSQLXML(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getSQLXML(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        String methodCall = "getSQLXML(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getSQLXML(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        String methodCall = "getNString(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getNString(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        String methodCall = "getNString(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getNString(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        String methodCall = "getNCharacterStream(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getNCharacterStream(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        String methodCall = "getNCharacterStream(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getNCharacterStream(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        String methodCall = "getCharacterStream(" + parameterIndex + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getCharacterStream(parameterIndex));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        String methodCall = "getCharacterStream(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getCharacterStream(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        String methodCall = "setBlob(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setBlob(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        String methodCall = "setClob(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setClob(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        String methodCall = "setAsciiStream(" + parameterName + ", " + x + ", " + length + ")";
        try {
            ((CallableStatement)this.delegate).setAsciiStream(parameterName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        String methodCall = "setBinaryStream(" + parameterName + ", " + x + ", " + length + ")";
        try {
            ((CallableStatement)this.delegate).setBinaryStream(parameterName, x, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        String methodCall = "setCharacterStream(" + parameterName + ", " + reader + ", " + length + ")";
        try {
            ((CallableStatement)this.delegate).setCharacterStream(parameterName, reader, length);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        String methodCall = "setAsciiStream(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setAsciiStream(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        String methodCall = "setBinaryStream(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setBinaryStream(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        String methodCall = "setCharacterStream(" + parameterName + ", " + reader + ")";
        try {
            ((CallableStatement)this.delegate).setCharacterStream(parameterName, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader reader) throws SQLException {
        String methodCall = "setNCharacterStream(" + parameterName + ", " + reader + ")";
        try {
            ((CallableStatement)this.delegate).setNCharacterStream(parameterName, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        String methodCall = "setClob(" + parameterName + ", " + reader + ")";
        try {
            ((CallableStatement)this.delegate).setClob(parameterName, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        String methodCall = "setBlob(" + parameterName + ", " + inputStream + ")";
        try {
            ((CallableStatement)this.delegate).setBlob(parameterName, inputStream);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        String methodCall = "setNClob(" + parameterName + ", " + reader + ")";
        try {
            ((CallableStatement)this.delegate).setNClob(parameterName, reader);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        String methodCall = "getObject(" + parameterIndex + ", " + type.getName() + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getObject(parameterIndex, type));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        String methodCall = "getObject(" + parameterName + ", " + type.getName() + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getObject(parameterName, type));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        String methodCall = "setObject(" + parameterName + ", " + x + ", " + targetSqlType + ", " + scaleOrLength + ")";
        try {
            ((CallableStatement)this.delegate).setObject(parameterName, x, targetSqlType, scaleOrLength);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        String methodCall = "setObject(" + parameterName + ", " + x + ", " + targetSqlType + ")";
        try {
            ((CallableStatement)this.delegate).setObject(parameterName, x, targetSqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterIndex + ", " + sqlType.getName() + ")";
        try {
            ((CallableStatement)this.delegate).registerOutParameter(parameterIndex, sqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterIndex + ", " + sqlType.getName() + ", " + scale + ")";
        try {
            ((CallableStatement)this.delegate).registerOutParameter(parameterIndex, sqlType, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterIndex + ", " + sqlType.getName() + ", " + typeName + ")";
        try {
            ((CallableStatement)this.delegate).registerOutParameter(parameterIndex, sqlType, typeName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterName + ", " + sqlType + ")";
        try {
            ((CallableStatement)this.delegate).registerOutParameter(parameterName, sqlType);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterName + ", " + sqlType.getName() + ", " + scale + ")";
        try {
            ((CallableStatement)this.delegate).registerOutParameter(parameterName, sqlType, scale);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        String methodCall = "registerOutParameter(" + parameterName + ", " + sqlType.getName() + ", " + typeName + ")";
        try {
            ((CallableStatement)this.delegate).registerOutParameter(parameterName, sqlType, typeName);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        String methodCall = "setURL(" + parameterName + ", " + val + ")";
        try {
            ((CallableStatement)this.delegate).setURL(parameterName, val);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        String methodCall = "getArray(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getArray(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        String methodCall = "getBlob(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getBlob(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        String methodCall = "getClob(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getClob(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        String methodCall = "getDate(" + parameterName + ")";
        try {
            return this.reportReturn(methodCall, ((CallableStatement)this.delegate).getDate(parameterName));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        String methodCall = "setDate(" + parameterName + ", " + x + ")";
        try {
            ((CallableStatement)this.delegate).setDate(parameterName, x);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodCall = "unwrap(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return (T)this.reportReturn(methodCall, iface != null && (iface == CallableStatement.class || iface == PreparedStatement.class || iface == Statement.class || iface == JdbcSpy.class) ? this : ((CallableStatement)this.delegate).unwrap(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodCall = "isWrapperFor(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return this.reportReturn(methodCall, iface != null && (iface == CallableStatement.class || iface == PreparedStatement.class || iface == Statement.class || iface == JdbcSpy.class) || ((CallableStatement)this.delegate).isWrapperFor(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }
}

