/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.log4jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.digitalforge.log4jdbc.JdbcSpy;
import org.digitalforge.log4jdbc.LoggingCallableStatement;
import org.digitalforge.log4jdbc.LoggingDriver;
import org.digitalforge.log4jdbc.LoggingPreparedStatement;
import org.digitalforge.log4jdbc.LoggingStatement;
import org.digitalforge.log4jdbc.SpyLogDelegator;
import org.digitalforge.log4jdbc.SpyLogFactory;
import org.digitalforge.log4jdbc.formatter.ParameterFormatter;
import org.digitalforge.log4jdbc.util.ConnectionTracker;

public class LoggingConnection
implements Connection,
JdbcSpy {
    private static final SpyLogDelegator log = SpyLogFactory.getSpyLogDelegator();
    private static final AtomicInteger connectionCounter = new AtomicInteger();
    private static final ConnectionTracker connectionTracker = new ConnectionTracker();
    private final int connectionNumber;
    private Connection delegate;
    private ParameterFormatter parameterFormatter;

    public static ConnectionTracker getConnectionTracker() {
        return connectionTracker;
    }

    public LoggingConnection(Connection delegate) {
        this(delegate, LoggingDriver.defaultParameterFormatter);
    }

    public LoggingConnection(Connection delegate, ParameterFormatter parameterFormatter) {
        if (delegate == null) {
            throw new IllegalArgumentException("Must pass in a non-null real Connection");
        }
        this.delegate = delegate;
        this.parameterFormatter = parameterFormatter != null ? parameterFormatter : LoggingDriver.defaultParameterFormatter;
        this.connectionNumber = connectionCounter.incrementAndGet();
        connectionTracker.track(this.connectionNumber, this);
        log.connectionOpened(this);
        this.reportReturn("New connection");
    }

    @Override
    public Integer getConnectionNumber() {
        return this.connectionNumber;
    }

    @Override
    public String getClassType() {
        return "Connection";
    }

    public Connection getDelegate() {
        return this.delegate;
    }

    ParameterFormatter getParameterFormatter() {
        return this.parameterFormatter;
    }

    void setParameterFormatter(ParameterFormatter parameterFormatter) {
        this.parameterFormatter = parameterFormatter;
    }

    protected void reportException(String methodCall, SQLException exception, String sql) {
        log.exceptionOccured(this, methodCall, exception, sql, -1L);
    }

    protected void reportException(String methodCall, SQLException exception) {
        log.exceptionOccured(this, methodCall, exception, null, -1L);
    }

    protected void reportAllReturns(String methodCall, String returnValue) {
        log.methodReturned(this, methodCall, returnValue);
    }

    private boolean reportReturn(String methodCall, boolean value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    private int reportReturn(String methodCall, int value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    private <T> T reportReturn(String methodCall, T value) {
        this.reportAllReturns(methodCall, "" + value);
        return value;
    }

    private void reportReturn(String methodCall) {
        this.reportAllReturns(methodCall, "");
    }

    @Override
    public boolean isClosed() throws SQLException {
        String methodCall = "isClosed()";
        try {
            return this.reportReturn(methodCall, this.delegate.isClosed());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        String methodCall = "getWarnings()";
        try {
            return this.reportReturn(methodCall, this.delegate.getWarnings());
        }
        catch (SQLException ex) {
            this.reportException(methodCall, ex);
            throw ex;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        String methodCall = "setSavepoint()";
        try {
            return this.reportReturn(methodCall, this.delegate.setSavepoint());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        String methodCall = "releaseSavepoint(" + savepoint + ")";
        try {
            this.delegate.releaseSavepoint(savepoint);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        String methodCall = "rollback(" + savepoint + ")";
        try {
            this.delegate.rollback(savepoint);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        String methodCall = "getMetaData()";
        try {
            return this.reportReturn(methodCall, this.delegate.getMetaData());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        String methodCall = "clearWarnings()";
        try {
            this.delegate.clearWarnings();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public Statement createStatement() throws SQLException {
        String methodCall = "createStatement()";
        try {
            Statement statement = this.delegate.createStatement();
            LoggingStatement<Statement> lstatement = this.reportReturn(methodCall, new LoggingStatement<Statement>(this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodCall = "createStatement(" + resultSetType + ", " + resultSetConcurrency + ")";
        try {
            Statement statement = this.delegate.createStatement(resultSetType, resultSetConcurrency);
            LoggingStatement<Statement> lstatement = this.reportReturn(methodCall, new LoggingStatement<Statement>(this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodCall = "createStatement(" + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")";
        try {
            Statement statement = this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            LoggingStatement<Statement> lstatement = this.reportReturn(methodCall, new LoggingStatement<Statement>(this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        String methodCall = "setReadOnly(" + readOnly + ")";
        try {
            this.delegate.setReadOnly(readOnly);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ")";
        try {
            PreparedStatement statement = this.delegate.prepareStatement(sql);
            LoggingPreparedStatement<PreparedStatement> lstatement = this.reportReturn(methodCall, new LoggingPreparedStatement<PreparedStatement>(sql, this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + autoGeneratedKeys + ")";
        try {
            PreparedStatement statement = this.delegate.prepareStatement(sql, autoGeneratedKeys);
            LoggingPreparedStatement<PreparedStatement> lstatement = this.reportReturn(methodCall, new LoggingPreparedStatement<PreparedStatement>(sql, this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ")";
        try {
            PreparedStatement statement = this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency);
            LoggingPreparedStatement<PreparedStatement> lstatement = this.reportReturn(methodCall, new LoggingPreparedStatement<PreparedStatement>(sql, this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")";
        try {
            PreparedStatement statement = this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            LoggingPreparedStatement<PreparedStatement> lstatement = this.reportReturn(methodCall, new LoggingPreparedStatement<PreparedStatement>(sql, this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + columnIndexes + ")";
        try {
            PreparedStatement statement = this.delegate.prepareStatement(sql, columnIndexes);
            LoggingPreparedStatement<PreparedStatement> lstatement = this.reportReturn(methodCall, new LoggingPreparedStatement<PreparedStatement>(sql, this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        String methodCall = "setSavepoint(" + name + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.setSavepoint(name));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String methodCall = "prepareStatement(" + sql + ", " + columnNames + ")";
        try {
            PreparedStatement statement = this.delegate.prepareStatement(sql, columnNames);
            LoggingPreparedStatement<PreparedStatement> lstatement = this.reportReturn(methodCall, new LoggingPreparedStatement<PreparedStatement>(sql, this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        String methodCall = "createClob()";
        try {
            return this.reportReturn(methodCall, this.delegate.createClob());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        String methodCall = "createBlob()";
        try {
            return this.reportReturn(methodCall, this.delegate.createBlob());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        String methodCall = "createNClob()";
        try {
            return this.reportReturn(methodCall, this.delegate.createNClob());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        String methodCall = "createSQLXML()";
        try {
            return this.reportReturn(methodCall, this.delegate.createSQLXML());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        String methodCall = "isValid(" + timeout + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.isValid(timeout));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        String methodCall = "setClientInfo(" + name + ", " + value + ")";
        try {
            this.delegate.setClientInfo(name, value);
        }
        catch (SQLClientInfoException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        String methodCall = "setClientInfo(" + properties + ")";
        try {
            this.delegate.setClientInfo(properties);
        }
        catch (SQLClientInfoException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        String methodCall = "getClientInfo(" + name + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.getClientInfo(name));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        String methodCall = "getClientInfo()";
        try {
            return this.reportReturn(methodCall, this.delegate.getClientInfo());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        String methodCall = "createArrayOf(" + typeName + ", " + elements + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.createArrayOf(typeName, elements));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        String methodCall = "createStruct(" + typeName + ", " + attributes + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.createStruct(typeName, attributes));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        String methodCall = "setSchema(" + schema + ")";
        try {
            this.delegate.setSchema(schema);
        }
        catch (SQLClientInfoException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String getSchema() throws SQLException {
        String methodCall = "getSchema()";
        try {
            return this.reportReturn(methodCall, this.delegate.getSchema());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        String methodCall = "abort(" + executor + ")";
        try {
            this.delegate.abort(executor);
        }
        catch (SQLClientInfoException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        String methodCall = "setNetworkTimeout(" + executor + ", " + milliseconds + ")";
        try {
            this.delegate.setNetworkTimeout(executor, milliseconds);
        }
        catch (SQLClientInfoException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        String methodCall = "getNetworkTimeout()";
        try {
            return this.reportReturn(methodCall, this.delegate.getNetworkTimeout());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        String methodCall = "isReadOnly()";
        try {
            return this.reportReturn(methodCall, this.delegate.isReadOnly());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        String methodCall = "setHoldability(" + holdability + ")";
        try {
            this.delegate.setHoldability(holdability);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        String methodCall = "prepareCall(" + sql + ")";
        try {
            CallableStatement statement = this.delegate.prepareCall(sql);
            LoggingCallableStatement<CallableStatement> lstatement = this.reportReturn(methodCall, new LoggingCallableStatement<CallableStatement>(sql, this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String methodCall = "prepareCall(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ")";
        try {
            CallableStatement statement = this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency);
            LoggingCallableStatement<CallableStatement> lstatement = this.reportReturn(methodCall, new LoggingCallableStatement<CallableStatement>(sql, this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String methodCall = "prepareCall(" + sql + ", " + resultSetType + ", " + resultSetConcurrency + ", " + resultSetHoldability + ")";
        try {
            CallableStatement statement = this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            LoggingCallableStatement<CallableStatement> lstatement = this.reportReturn(methodCall, new LoggingCallableStatement<CallableStatement>(sql, this, statement));
            connectionTracker.track(lstatement);
            return lstatement;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        String methodCall = "setCatalog(" + catalog + ")";
        try {
            this.delegate.setCatalog(catalog);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        String methodCall = "nativeSQL(" + sql + ")";
        try {
            return this.reportReturn(methodCall, this.delegate.nativeSQL(sql));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s, sql);
            throw s;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        String methodCall = "getTypeMap()";
        try {
            return this.reportReturn(methodCall, this.delegate.getTypeMap());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        String methodCall = "setAutoCommit(" + autoCommit + ")";
        try {
            this.delegate.setAutoCommit(autoCommit);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public String getCatalog() throws SQLException {
        String methodCall = "getCatalog()";
        try {
            return this.reportReturn(methodCall, this.delegate.getCatalog());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        String methodCall = "setTypeMap(" + map + ")";
        try {
            this.delegate.setTypeMap(map);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        String methodCall = "setTransactionIsolation(" + level + ")";
        try {
            this.delegate.setTransactionIsolation(level);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        String methodCall = "getAutoCommit()";
        try {
            return this.reportReturn(methodCall, this.delegate.getAutoCommit());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        String methodCall = "getHoldability()";
        try {
            return this.reportReturn(methodCall, this.delegate.getHoldability());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        String methodCall = "getTransactionIsolation()";
        try {
            return this.reportReturn(methodCall, this.delegate.getTransactionIsolation());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public void commit() throws SQLException {
        String methodCall = "commit()";
        try {
            this.delegate.commit();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void rollback() throws SQLException {
        String methodCall = "rollback()";
        try {
            this.delegate.rollback();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        this.reportReturn(methodCall);
    }

    @Override
    public void close() throws SQLException {
        String methodCall = "close()";
        try {
            this.delegate.close();
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
        finally {
            connectionTracker.untrack(this.connectionNumber);
            log.connectionClosed(this);
        }
        this.reportReturn(methodCall);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        String methodCall = "unwrap(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return (T)this.reportReturn(methodCall, iface != null && (iface == Connection.class || iface == JdbcSpy.class) ? this : this.delegate.unwrap(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        String methodCall = "isWrapperFor(" + (iface == null ? "null" : iface.getName()) + ")";
        try {
            return this.reportReturn(methodCall, iface != null && (iface == Connection.class || iface == JdbcSpy.class) || this.delegate.isWrapperFor(iface));
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }
}

