/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.log4jdbc;

import org.digitalforge.log4jdbc.JdbcSpy;
import org.digitalforge.log4jdbc.LoggingConnection;
import org.digitalforge.log4jdbc.LoggingDriver;
import org.digitalforge.log4jdbc.SpyLogDelegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Slf4jSpyLogDelegator
implements SpyLogDelegator {
    public static ExecutionTimeMarkerFactory markerFactory = new ExecutionTimeMarkerFactory(){

        @Override
        public Marker create(String sql, long executionTimeNanoSec) {
            return MarkerFactory.getMarker((String)("{\"sql\"=\"" + sql + "\",\"executedInNanoSec\"=" + executionTimeNanoSec + "}"));
        }
    };
    private final Logger jdbcLogger = LoggerFactory.getLogger((String)"jdbc.audit");
    private final Logger resultSetLogger = LoggerFactory.getLogger((String)"jdbc.resultset");
    private final Logger sqlOnlyLogger = LoggerFactory.getLogger((String)"jdbc.sqlonly");
    private final Logger sqlTimingLogger = LoggerFactory.getLogger((String)"jdbc.sqltiming");
    private final Logger connectionLogger = LoggerFactory.getLogger((String)"jdbc.connection");
    private final Logger debugLogger = LoggerFactory.getLogger((String)"log4jdbc.debug");
    private static final String NEWLINE = System.getProperty("line.separator");

    @Override
    public boolean isJdbcLoggingEnabled() {
        return this.jdbcLogger.isErrorEnabled() || this.resultSetLogger.isErrorEnabled() || this.sqlOnlyLogger.isErrorEnabled() || this.sqlTimingLogger.isErrorEnabled() || this.connectionLogger.isErrorEnabled();
    }

    @Override
    public void exceptionOccured(JdbcSpy spy, String methodCall, Exception ex, String sql, long execTimeNanoSec) {
    }

    @Override
    public void methodReturned(JdbcSpy spy, String methodCall, String returnMsg) {
        Logger logger;
        String classType = spy.getClassType();
        Logger logger2 = logger = "ResultSet".equals(classType) ? this.resultSetLogger : this.jdbcLogger;
        if (logger.isInfoEnabled()) {
            String header = spy.getConnectionNumber() + ". " + classType + "." + methodCall + " returned " + returnMsg;
            if (logger.isDebugEnabled()) {
                logger.debug(header + " " + Slf4jSpyLogDelegator.getDebugInfo());
            } else {
                logger.info(header);
            }
        }
    }

    @Override
    public void constructorReturned(JdbcSpy spy, String constructionInfo) {
    }

    private boolean shouldSqlBeLogged(String sql) {
        if (sql == null) {
            return false;
        }
        if ((sql = sql.trim()).length() < 6) {
            return false;
        }
        sql = sql.substring(0, 6).toLowerCase();
        return LoggingDriver.config.isDumpSqlSelect() && "select".equals(sql) || LoggingDriver.config.isDumpSqlInsert() && "insert".equals(sql) || LoggingDriver.config.isDumpSqlUpdate() && "update".equals(sql) || LoggingDriver.config.isDumpSqlDelete() && "delete".equals(sql) || LoggingDriver.config.isDumpSqlCreate() && "create".equals(sql);
    }

    public boolean shouldUseMarkersForTimingReports() {
        return LoggingDriver.config.isShouldUseMarkersForTimingReports();
    }

    @Override
    public void sqlOccured(JdbcSpy spy, String methodCall, String sql) {
        sql = LoggingDriver.sqlPrettifier.prettifySql(sql);
        if (!LoggingDriver.config.isDumpSqlFilteringOn() || this.shouldSqlBeLogged(sql)) {
            if (this.sqlOnlyLogger.isDebugEnabled()) {
                this.sqlOnlyLogger.debug(Slf4jSpyLogDelegator.getDebugInfo() + NEWLINE + spy.getConnectionNumber() + ". " + this.processSql(sql));
            } else if (this.sqlOnlyLogger.isInfoEnabled()) {
                this.sqlOnlyLogger.info(this.processSql(sql));
            }
        }
    }

    private String processSql(String sql) {
        if (sql == null) {
            return null;
        }
        if (LoggingDriver.config.isTrimSql()) {
            sql = sql.trim();
        }
        return sql;
    }

    @Override
    public void sqlTimingOccured(JdbcSpy spy, long execTimeNanoSec, String methodCall, String sql) {
        if (!this.shouldReportTimingOccured(sql = LoggingDriver.sqlPrettifier.prettifySql(sql))) {
            return;
        }
        String message = this.buildSqlTimingDump(spy, execTimeNanoSec, methodCall, sql, this.sqlTimingLogger.isDebugEnabled());
        Marker marker = markerFactory.create(sql, execTimeNanoSec);
        if (LoggingDriver.config.isSqlTimingErrorThresholdEnabled() && execTimeNanoSec >= LoggingDriver.config.getSqlTimingErrorThresholdNanoSec()) {
            if (this.shouldUseMarkersForTimingReports()) {
                this.sqlTimingLogger.error(marker, message);
            } else {
                this.sqlTimingLogger.error(message);
            }
            return;
        }
        if (!this.sqlTimingLogger.isWarnEnabled()) {
            return;
        }
        if (LoggingDriver.config.isSqlTimingWarnThresholdEnabled() && execTimeNanoSec >= LoggingDriver.config.getSqlTimingWarnThresholdNanoSec()) {
            if (this.shouldUseMarkersForTimingReports()) {
                this.sqlTimingLogger.warn(marker, message);
            } else {
                this.sqlTimingLogger.warn(message);
            }
        } else if (this.sqlTimingLogger.isDebugEnabled()) {
            if (this.shouldUseMarkersForTimingReports()) {
                this.sqlTimingLogger.debug(marker, message);
            } else {
                this.sqlTimingLogger.debug(message);
            }
        } else if (this.sqlTimingLogger.isInfoEnabled()) {
            if (this.shouldUseMarkersForTimingReports()) {
                this.sqlTimingLogger.info(marker, message);
            } else {
                this.sqlTimingLogger.info(message);
            }
        }
    }

    private boolean shouldReportTimingOccured(String sql) {
        return this.sqlTimingLogger.isErrorEnabled() && (!LoggingDriver.config.isDumpSqlFilteringOn() || this.shouldSqlBeLogged(sql));
    }

    private String buildSqlTimingDump(JdbcSpy spy, long execTimeNanoSec, String methodCall, String sql, boolean debugInfo) {
        StringBuffer out = new StringBuffer();
        if (debugInfo) {
            out.append(Slf4jSpyLogDelegator.getDebugInfo());
            out.append(NEWLINE);
            out.append(spy.getConnectionNumber());
            out.append(". ");
        }
        sql = this.processSql(sql);
        out.append(sql);
        if (!this.shouldUseMarkersForTimingReports()) {
            out.append(" {executed in ");
            out.append(execTimeNanoSec);
            out.append(" nanoSec}");
        }
        return out.toString();
    }

    private static String getDebugInfo() {
        Throwable t = new Throwable();
        t.fillInStackTrace();
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace != null) {
            StringBuffer dump = new StringBuffer();
            if (LoggingDriver.config.isDumpFullDebugStackTrace()) {
                boolean first = true;
                for (int i = 0; i < stackTrace.length; ++i) {
                    String className = stackTrace[i].getClassName();
                    if (className.startsWith("net.sf.log4jdbc") || className.startsWith("com.orderlyhealth.log4jdbc")) continue;
                    if (first) {
                        first = false;
                    } else {
                        dump.append("  ");
                    }
                    dump.append("at ");
                    dump.append(stackTrace[i]);
                    dump.append(NEWLINE);
                }
            } else {
                int j;
                dump.append(" ");
                int firstLog4jdbcCall = 0;
                int lastApplicationCall = 0;
                for (int i = 0; i < stackTrace.length; ++i) {
                    String className = stackTrace[i].getClassName();
                    if (className.startsWith("net.sf.log4jdbc") || className.startsWith("com.orderlyhealth.log4jdbc")) {
                        firstLog4jdbcCall = i;
                        continue;
                    }
                    if (!LoggingDriver.config.isTraceFromApplication() || !className.startsWith(LoggingDriver.config.getDebugStackPrefix())) continue;
                    lastApplicationCall = i;
                    break;
                }
                if ((j = lastApplicationCall) == 0) {
                    j = 1 + firstLog4jdbcCall;
                }
                dump.append(stackTrace[j].getClassName()).append(".").append(stackTrace[j].getMethodName()).append("(").append(stackTrace[j].getFileName()).append(":").append(stackTrace[j].getLineNumber()).append(")");
            }
            return dump.toString();
        }
        return null;
    }

    @Override
    public void debug(String msg) {
        this.debugLogger.debug(msg);
    }

    @Override
    public void connectionOpened(JdbcSpy spy) {
        if (this.connectionLogger.isDebugEnabled()) {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection opened " + Slf4jSpyLogDelegator.getDebugInfo());
            this.connectionLogger.debug(LoggingConnection.getConnectionTracker().getOpenConnectionsDump());
        } else {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection opened");
        }
    }

    @Override
    public void connectionClosed(JdbcSpy spy) {
        if (this.connectionLogger.isDebugEnabled()) {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection closed " + Slf4jSpyLogDelegator.getDebugInfo());
            this.connectionLogger.debug(LoggingConnection.getConnectionTracker().getOpenConnectionsDump());
        } else {
            this.connectionLogger.info(spy.getConnectionNumber() + ". Connection closed");
        }
    }

    public static interface ExecutionTimeMarkerFactory {
        public Marker create(String var1, long var2);
    }
}

