/*
 * Decompiled with CFR 0.152.
 */
package org.digitalforge.log4jdbc.formatter;

import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.digitalforge.log4jdbc.util.Utilities;

public class ParameterFormatter {
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss.SSS");

    public String formatParameterObject(Object object) {
        if (object == null) {
            return "NULL";
        }
        if (object instanceof CharSequence) {
            return "'" + this.escapeString((CharSequence)object) + "'";
        }
        if (object instanceof Date) {
            return "'" + DATETIME_FORMATTER.format(((Date)object).toInstant()) + "'";
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? "1" : "0";
        }
        if (object instanceof byte[] && ((byte[])object).length <= 48) {
            return "0x" + Utilities.hex((byte[])object).toUpperCase();
        }
        return object.toString();
    }

    String escapeString(CharSequence in) {
        StringBuilder out = new StringBuilder();
        int j = in.length();
        for (int i = 0; i < j; ++i) {
            char c = in.charAt(i);
            if (c == '\'') {
                out.append(c);
            }
            out.append(c);
        }
        return out.toString();
    }
}

