/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.io.IOException;
import org.directwebremoting.ScriptBuffer;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.ScriptConduit;
import org.directwebremoting.proxy.ScriptProxy;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.Logger;

public class EnginePrivate
extends ScriptProxy {
    private static final Logger log = Logger.getLogger(class$org$directwebremoting$extend$EnginePrivate == null ? (class$org$directwebremoting$extend$EnginePrivate = EnginePrivate.class$("org.directwebremoting.extend.EnginePrivate")) : class$org$directwebremoting$extend$EnginePrivate);
    static /* synthetic */ Class class$org$directwebremoting$extend$EnginePrivate;

    public static void remoteHandleCallback(ScriptConduit conduit, String batchId, String callId, Object data) throws IOException, MarshallException {
        ScriptBuffer script = new ScriptBuffer();
        script.appendScript("dwr.engine._remoteHandleCallback('").appendScript(batchId).appendScript("','").appendScript(callId).appendScript("',").appendData(data).appendScript(");");
        conduit.addScript(script);
    }

    public static void remoteHandleMarshallException(ScriptConduit conduit, String batchId, String callId, MarshallException ex) throws IOException {
        try {
            ScriptBuffer script = new ScriptBuffer();
            script.appendScript("dwr.engine._remoteHandleException('").appendScript(batchId).appendScript("','").appendScript(callId).appendScript("',").appendData(ex).appendScript(");");
            conduit.addScript(script);
        }
        catch (MarshallException mex) {
            ScriptBuffer script = new ScriptBuffer();
            script.appendScript("dwr.engine._remoteHandleException('").appendScript(batchId).appendScript("','").appendScript(callId).appendScript("',").appendData(ex).appendScript(");");
            EnginePrivate.addScriptWithoutException(conduit, script);
        }
    }

    public static void remoteHandleException(ScriptConduit conduit, String batchId, String callId, Throwable ex) throws IOException {
        try {
            ScriptBuffer script = new ScriptBuffer();
            script.appendScript("dwr.engine._remoteHandleException('").appendScript(batchId).appendScript("','").appendScript(callId).appendScript("',").appendData(ex).appendScript(");");
            conduit.addScript(script);
        }
        catch (MarshallException mex) {
            ScriptBuffer script = new ScriptBuffer();
            script.appendScript("dwr.engine._remoteHandleException('").appendScript(batchId).appendScript("','").appendScript(callId).appendScript("',").appendData(ex).appendScript(");");
            EnginePrivate.addScriptWithoutException(conduit, script);
        }
    }

    public static String getRemoteHandleBatchExceptionScript(String batchId, Exception ex) {
        StringBuffer reply = new StringBuffer();
        String output = JavascriptUtil.escapeJavaScript(ex.getMessage());
        String params = "{ name:'" + ex.getClass().getName() + "', message:'" + output + "' }";
        if (batchId != null) {
            params = params + ", '" + batchId + "'";
        }
        reply.append("//#DWR-REPLY").append("\r\n");
        reply.append("if (window.dwr) dwr.engine._remoteHandleBatchException(").append(params).append(");\r\n");
        reply.append("else if (window.parent.dwr) window.parent.dwr.engine._remoteHandleBatchException(").append(params).append(");\r\n");
        return reply.toString();
    }

    public static String getRemotePollCometDisabledScript(String batchId) {
        StringBuffer reply = new StringBuffer();
        String params = "{ name:'dwr.engine.pollAndCometDisabled', message:'Polling and Comet are disabled. See the server logs.' }";
        if (batchId != null) {
            params = params + ", '" + batchId + "'";
        }
        reply.append("//#DWR-REPLY").append("\r\n");
        reply.append("if (window.dwr) dwr.engine._remotePollCometDisabled(").append(params).append(");\r\n");
        reply.append("else if (window.parent.dwr) window.parent.dwr.engine._remotePollCometDisabled(").append(params).append(");\r\n");
        return reply.toString();
    }

    public static String xmlStringToJavascriptDom(String xml) {
        String xmlout = JavascriptUtil.escapeJavaScript(xml);
        return "dwr.engine._unserializeDocument(\"" + xmlout + "\")";
    }

    public static String getEngineInitScript() {
        return "// Provide a default path to dwr.engine\nif (dwr == null) var dwr = {};\nif (dwr.engine == null) dwr.engine = {};\nif (DWREngine == null) var DWREngine = dwr.engine;\n\n";
    }

    public static String getExecuteFunctionName() {
        return "dwr.engine._execute";
    }

    public static String remoteBeginIFrameResponse(String batchId, boolean useWindowParent) {
        String prefix = "";
        if (useWindowParent) {
            prefix = "window.parent.";
        }
        return prefix + "dwr.engine._remoteBeginIFrameResponse(this.frameElement" + (batchId == null ? "" : ", '" + batchId + "'") + ");";
    }

    public static String remoteEndIFrameResponse(String batchId, boolean useWindowParent) {
        String prefix = "";
        if (useWindowParent) {
            prefix = "window.parent.";
        }
        return prefix + "dwr.engine._remoteEndIFrameResponse(" + (batchId == null ? "" : "'" + batchId + "'") + ");";
    }

    public static String remoteEval(String script) {
        return "window.parent.dwr.engine._eval(\"" + JavascriptUtil.escapeJavaScript(script) + "\");";
    }

    private static void addScriptWithoutException(ScriptConduit conduit, ScriptBuffer script) throws IOException {
        try {
            conduit.addScript(script);
        }
        catch (MarshallException ex) {
            log.warn("This exception can't happen", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

