/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModifiableServletConfig
implements ServletConfig {
    private final ServletConfig servletConfig;
    private final Map<String, String> overrides = Collections.synchronizedMap(new HashMap());

    ModifiableServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public String getInitParameter(String name) {
        if (this.overrides.containsKey(name)) {
            return this.overrides.get(name);
        }
        return this.servletConfig.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        HashSet<String> names = new HashSet<String>();
        Enumeration enumeration = this.servletConfig.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            names.add(enumeration.nextElement().toString());
        }
        names.addAll(this.overrides.keySet());
        return ModifiableServletConfig.toEnumeration(names.iterator());
    }

    public ServletContext getServletContext() {
        return this.servletConfig.getServletContext();
    }

    public String getServletName() {
        return this.servletConfig.getServletName();
    }

    public void setInitParameter(String name, String value) {
        this.overrides.put(name, value);
    }

    private static <E> Enumeration<E> toEnumeration(final Iterator<E> iterator) {
        return new Enumeration<E>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public E nextElement() {
                return iterator.next();
            }
        };
    }
}

