/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.starter;

import org.dromara.easyes.common.property.EasyEsDynamicProperties;
import org.dromara.easyes.common.property.EasyEsProperties;
import org.dromara.easyes.common.utils.RestHighLevelClientUtils;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={RestHighLevelClient.class})
@ConditionalOnExpression(value="'${easy-es.address:x}'!='x'")
@ConditionalOnProperty(prefix="easy-es", name={"enable"}, havingValue="true", matchIfMissing=true)
public class EsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public RestHighLevelClient restHighLevelClient() {
        return RestHighLevelClientUtils.restHighLevelClient((EasyEsProperties)this.easyEsProperties());
    }

    @Bean
    @ConfigurationProperties(prefix="easy-es")
    public EasyEsProperties easyEsProperties() {
        return new EasyEsProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="easy-es.dynamic")
    public EasyEsDynamicProperties easyEsDynamicProperties() {
        return new EasyEsDynamicProperties();
    }
}

