/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.common.utils;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class MyOptional<T> {
    private static final MyOptional<?> EMPTY = new MyOptional();
    private final T value;

    private MyOptional() {
        this.value = null;
    }

    public static <T> MyOptional<T> empty() {
        MyOptional<?> t = EMPTY;
        return t;
    }

    private MyOptional(T value) {
        this.value = Objects.requireNonNull(value);
    }

    public static <T> MyOptional<T> of(T value) {
        return new MyOptional<T>(value);
    }

    public static <T> MyOptional<T> ofNullable(T value) {
        return value == null ? MyOptional.empty() : MyOptional.of(value);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifTrue(Consumer<? super T> consumer) {
        boolean condition;
        if (this.value != null && this.value instanceof Boolean && (condition = ((Boolean)this.value).booleanValue())) {
            consumer.accept(this.value);
        }
    }

    public void ifPresent(Consumer<? super T> present, Supplier<?> other) {
        if (this.value != null) {
            present.accept(this.value);
        } else {
            other.get();
        }
    }

    public <U> MyOptional<U> ifPresent(Function<? super T, ? extends U> present, T otherValue) {
        Objects.requireNonNull(present);
        if (this.isPresent()) {
            return MyOptional.ofNullable(present.apply(this.value));
        }
        return MyOptional.ofNullable(present.apply(otherValue));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MyOptional)) {
            return false;
        }
        MyOptional other = (MyOptional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? String.format("MyOptional[%s]", this.value) : "MyOptional.empty";
    }
}

