/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.spring;

import java.util.Map;
import java.util.Optional;
import org.dromara.easyes.common.utils.EEVersionUtils;
import org.dromara.easyes.common.utils.LogUtils;
import org.dromara.easyes.spring.config.ClassPathMapperScanner;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class MapperScannerConfigurer
implements BeanDefinitionRegistryPostProcessor,
InitializingBean,
ApplicationContextAware,
BeanNameAware {
    private String basePackage;
    private ApplicationContext applicationContext;
    private String beanName;

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        Boolean enable = (Boolean)this.getEnvironment().getProperty("easy-es.enable", Boolean.TYPE, (Object)true);
        if (!enable.booleanValue()) {
            LogUtils.info((String[])new String[]{"===> Easy-Es is not enabled"});
            return;
        }
        this.printBanner();
        Map prcs = this.applicationContext.getBeansOfType(PropertyResourceConfigurer.class, false, false);
        if (!prcs.isEmpty() && this.applicationContext instanceof ConfigurableApplicationContext) {
            BeanDefinition mapperScannerBean = ((ConfigurableApplicationContext)this.applicationContext).getBeanFactory().getBeanDefinition(this.beanName);
            DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
            factory.registerBeanDefinition(this.beanName, mapperScannerBean);
            for (PropertyResourceConfigurer prc : prcs.values()) {
                prc.postProcessBeanFactory((ConfigurableListableBeanFactory)factory);
            }
            MutablePropertyValues values = mapperScannerBean.getPropertyValues();
            this.basePackage = this.getPropertyValue("basePackage", (PropertyValues)values);
        }
        this.basePackage = Optional.ofNullable(this.basePackage).map(arg_0 -> ((Environment)this.getEnvironment()).resolvePlaceholders(arg_0)).orElse(null);
        ClassPathMapperScanner scanner = new ClassPathMapperScanner(beanDefinitionRegistry, this.getEnvironment());
        scanner.registerFilters();
        scanner.doScan(this.basePackage);
    }

    private String getPropertyValue(String propertyName, PropertyValues values) {
        PropertyValue property = values.getPropertyValue(propertyName);
        if (property == null) {
            return null;
        }
        Object value = property.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value.toString();
        }
        if (value instanceof TypedStringValue) {
            return ((TypedStringValue)value).getValue();
        }
        return null;
    }

    private Environment getEnvironment() {
        return this.applicationContext.getEnvironment();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.basePackage, (String)"Property 'basePackage' is required. mapper\u626b\u5305\u8def\u5f84\u4e3a\u5fc5\u586b\u3002");
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void printBanner() {
        Boolean banner = (Boolean)this.getEnvironment().getProperty("easy-es.banner", Boolean.class, (Object)true);
        if (banner.booleanValue()) {
            Boolean iKunMode = (Boolean)this.getEnvironment().getProperty("easy-es.global-config.i-kun-mode", Boolean.TYPE, (Object)false);
            String versionStr = EEVersionUtils.getJarVersion(this.getClass());
            String wechatStr = ":: wechat    :: 252645816, add and become muscle man!      >";
            if (iKunMode.booleanValue()) {
                System.out.println("                 \u9e21\u4f60\u592a\u7f8e\n               \u9e21\u4f60\u5b9e\u5728\u592a\u7f8e\n                \u9e21\u4f60\u662f\u592a\u7f8e\n                 \u9e21\u4f60\u592a\u7f8e\n              \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u4f60\n         \u9e21\u4f60 \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u4f60 \u7f8e\n       \u9e21\u4f60  \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u7f8e   \u592a\u7f8e\n      \u9e21\u4f60  \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u7f8e      \u592a\u7f8e\n    \u9e21\u4f60    \u5b9e\u5728\u662f\u592a\u7f8e\u9e21\u7f8e       \u592a\u7f8e\n   \u9e21\u4f60    \u9e21\u4f60\u5b9e\u5728\u662f\u7f8e\u592a\u7f8e    \u7f8e\u84dd\u7403\u7403\u7403\n\u9e21 \u9e21     \u9e21\u4f60\u5b9e\u5728\u662f\u592a\u7f8e     \u7bee\u7403\u7bee\u7403\u7403\u7403\u7403\n \u9e21      \u9e21\u4f60\u592a\u7f8e\u88c6\u9e21\u592a\u554a     \u7403\u7403\u84dd\u7bee\u7403\u7403\n         \u9e21\u4f60\u592a\u7f8e\u88c6\u88c6\u9e21\u7f8e       \u7403\u7403\u7403\n          \u9e21\u4f60\u88c6\u5c0f j \u9e21\u592a\u7f8e\n           \u9e21\u592a\u7f8e    \u9e21\u592a\u7f8e\n            \u9e21\u7f8e      \u9e21\u7f8e\n            \u9e21\u7f8e       \u9e21\u7f8e\n             \u9e21\u7f8e       \u9e21\u7f8e\n             \u9e21\u592a       \u9e21\u592a\n           \u9e21 \u811a       \u9e21\u811a\n           \u76ae \u978b       \u76ae\u978b\u91d1\u7334\n            \u91d1\u5149       \u91d1\u5149 \u5927\u9053\n           \u5927\u9053\n      \u9e21\u795e\u4fdd\u4f51       \u6c38\u4e0d\u5b95\u673a     \u6c38\u65e0BUG");
                wechatStr = ":: wechat    :: 252645816, add and join ikun(\u5c0f\u9ed1\u5b50) group! >";
            } else {
                System.out.println("\n___                     _  _            ___\n  | __|   __ _     ___    | || |   ___    | __|    ___\n  | _|   / _` |   (_-<     \\_, |  |___|   | _|    (_-<\n  |___|  \\__,_|   /__/_   _|__/   _____   |___|   /__/_\n_|\"\"\"\"\"|_|\"\"\"\"\"|_|\"\"\"\"\"|_| \"\"\"\"|_|     |_|\"\"\"\"\"|_|\"\"\"\"\"|\n\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\"`-0-0-'\n----------------------------------------------------------->");
            }
            int width = 43;
            int blank = width - versionStr.length();
            StringBuilder sb = new StringBuilder();
            sb.append(":: version   :: ").append(versionStr);
            for (int i = 0; i < blank; ++i) {
                sb.append(" ");
            }
            sb.append(">");
            if (iKunMode.booleanValue()) {
                System.out.println("----------------------------------------------------------->");
            }
            System.out.println(":: project   :: Easy-Es                                    >");
            System.out.println(sb);
            System.out.println(":: home      :: https://easy-es.cn/                        >");
            System.out.println(":: community :: https://dromara.org/                       >");
            System.out.println(wechatStr);
            System.out.println("----------------------------------------------------------->");
        }
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }
}

