/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.easyes.spring.config;

import java.util.Map;
import org.dromara.easyes.common.property.EasyEsDynamicProperties;
import org.dromara.easyes.common.property.EasyEsProperties;
import org.dromara.easyes.common.strategy.AutoProcessIndexStrategy;
import org.dromara.easyes.common.utils.RestHighLevelClientUtils;
import org.dromara.easyes.core.index.AutoProcessIndexNotSmoothlyStrategy;
import org.dromara.easyes.core.index.AutoProcessIndexSmoothlyStrategy;
import org.dromara.easyes.spring.factory.IndexStrategyFactory;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
public class EasyEsConfiguration
implements InitializingBean {
    private EasyEsProperties easyEsProperties;
    private EasyEsDynamicProperties easyEsDynamicProperties;

    @Autowired
    public EasyEsConfiguration(EasyEsProperties easyEsProperties, EasyEsDynamicProperties easyEsDynamicProperties) {
        this.easyEsProperties = easyEsProperties;
        this.easyEsDynamicProperties = easyEsDynamicProperties;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.easyEsProperties, (String)"easyEsProperties must is A bean. easy-es\u914d\u7f6e\u7c7b\u5fc5\u987b\u7ed9\u914d\u7f6e\u4e00\u4e2abean");
    }

    @Bean
    public IndexStrategyFactory indexStrategyFactory() {
        return new IndexStrategyFactory();
    }

    @Bean
    public RestHighLevelClientUtils restHighLevelClientUtils() {
        Map datasourceMap;
        RestHighLevelClientUtils restHighLevelClientUtils = new RestHighLevelClientUtils();
        if (this.easyEsDynamicProperties == null) {
            this.easyEsDynamicProperties = new EasyEsDynamicProperties();
        }
        if ((datasourceMap = this.easyEsDynamicProperties.getDatasource()).isEmpty()) {
            datasourceMap.put("DEFAULT_DS", this.easyEsProperties);
        }
        for (String key : datasourceMap.keySet()) {
            EasyEsProperties easyEsConfigProperties = (EasyEsProperties)datasourceMap.get(key);
            RestHighLevelClientUtils.registerRestHighLevelClient((String)key, (RestHighLevelClient)RestHighLevelClientUtils.restHighLevelClient((EasyEsProperties)easyEsConfigProperties));
        }
        return restHighLevelClientUtils;
    }

    @Bean
    public AutoProcessIndexStrategy autoProcessIndexSmoothlyStrategy() {
        return new AutoProcessIndexSmoothlyStrategy();
    }

    @Bean
    public AutoProcessIndexStrategy autoProcessIndexNotSmoothlyStrategy() {
        return new AutoProcessIndexNotSmoothlyStrategy();
    }

    public void setEasyEsProperties(EasyEsProperties easyEsProperties) {
        this.easyEsProperties = easyEsProperties;
    }

    public void setEasyEsDynamicProperties(EasyEsDynamicProperties easyEsDynamicProperties) {
        this.easyEsDynamicProperties = easyEsDynamicProperties;
    }
}

