/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.array;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.func.Wrapper;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.util.ObjUtil;

public class ArrayWrapper<A, E>
implements Wrapper<A>,
Iterable<E> {
    private final Class<E> componentType;
    private A array;
    private int length;

    public static <A, E> ArrayWrapper<A, E> of(Class<E> componentType, int length) {
        return ArrayWrapper.of(Array.newInstance(componentType, length));
    }

    public static <A, E> ArrayWrapper<A, E> of(A array) {
        return new ArrayWrapper<A, E>(array);
    }

    public ArrayWrapper(A array) {
        Assert.notNull(array, "Array must be not null!", new Object[0]);
        if (!ArrayUtil.isArray(array)) {
            throw new IllegalArgumentException("Object is not a array!");
        }
        this.componentType = array.getClass().getComponentType();
        this.setNewArray(array);
    }

    @Override
    public A getRaw() {
        return this.array;
    }

    public int length() {
        return this.length;
    }

    public boolean isPrimitive() {
        return this.componentType.isPrimitive();
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    public Class<?> getArrayType() {
        return this.array.getClass();
    }

    public boolean isEmpty() {
        return 0 == this.length;
    }

    public E get(int index) {
        int length = this.length;
        if (index < 0) {
            index += length;
        }
        if (index < 0 || index >= length) {
            return null;
        }
        return (E)Array.get(this.array, index);
    }

    public E firstNonNull() {
        return (E)this.firstMatch(ObjUtil::isNotNull);
    }

    public E firstMatch(Predicate<E> matcher) {
        int index = this.matchIndex(matcher);
        if (index == -1) {
            return null;
        }
        return this.get(index);
    }

    public int indexOf(Object value) {
        return this.matchIndex(obj -> ObjUtil.equals(value, obj));
    }

    public int matchIndex(Predicate<E> matcher) {
        return this.matchIndex(0, matcher);
    }

    public int indexOf(Object value, int offset) {
        return this.matchIndex(offset, obj -> ObjUtil.equals(value, obj));
    }

    public int matchIndex(int offset, Predicate<E> matcher) {
        if (null == matcher && offset < this.length) {
            return offset;
        }
        for (int i = offset; i < this.length; ++i) {
            if (!matcher.test(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object value) {
        return this.matchLastIndex(obj -> ObjUtil.equals(value, obj));
    }

    public int matchLastIndex(Predicate<E> matcher) {
        return this.matchLastIndex(this.length - 1, matcher);
    }

    public int matchLastIndex(int offset, Predicate<E> matcher) {
        if (null == matcher && offset >= 0) {
            return offset;
        }
        for (int i = Math.min(offset, this.length - 1); i >= 0; --i) {
            if (!matcher.test(this.get(i))) continue;
            return i;
        }
        return -1;
    }

    public ArrayWrapper<A, E> setOrAppend(int index, E value) {
        if (index < this.length) {
            Array.set(this.array, index, value);
        } else {
            this.append(value);
        }
        return this;
    }

    public ArrayWrapper<A, E> append(E element) {
        return this.insert(this.length, element);
    }

    public ArrayWrapper<A, E> appendArray(A array) {
        return this.insertArray(this.length, array);
    }

    public ArrayWrapper<A, E> insert(int index, E element) {
        return this.insertArray(index, ArrayUtil.ofArray(element));
    }

    public ArrayWrapper<A, E> insertArray(int index, A arrayToInsert) {
        int appendLength = ArrayUtil.length(arrayToInsert);
        if (0 == appendLength) {
            return this;
        }
        if (this.isEmpty()) {
            this.setNewArray(Convert.convert(this.array.getClass(), arrayToInsert));
            return this;
        }
        int len = this.length;
        if (index < 0) {
            index = index % len + len;
        }
        if (this.componentType.isPrimitive()) {
            arrayToInsert = Convert.convert(this.array.getClass(), arrayToInsert);
        }
        Object result = Array.newInstance(this.componentType, Math.max(len, index) + appendLength);
        System.arraycopy(this.array, 0, result, 0, Math.min(len, index));
        System.arraycopy(arrayToInsert, 0, result, index, appendLength);
        if (index < len) {
            System.arraycopy(this.array, index, result, index + appendLength, len - index);
        }
        this.setNewArray(result);
        return this;
    }

    public ArrayWrapper<A, E> replace(int index, A values) {
        int valuesLength = ArrayUtil.length(values);
        if (0 == valuesLength) {
            return this;
        }
        if (this.isEmpty()) {
            this.setNewArray(Convert.convert(this.array.getClass(), values));
        }
        if (index < 0) {
            return this.insertArray(0, values);
        }
        if (index >= this.length) {
            return this.appendArray(values);
        }
        if (this.length >= valuesLength + index) {
            System.arraycopy(values, 0, this.array, index, valuesLength);
            return this;
        }
        Object result = Array.newInstance(this.componentType, index + valuesLength);
        System.arraycopy(this.array, 0, result, 0, index);
        System.arraycopy(values, 0, result, index, valuesLength);
        this.setNewArray(result);
        return this;
    }

    public ArrayWrapper<A, E> edit(UnaryOperator<E> editor) {
        if (null == this.array || null == editor) {
            return this;
        }
        for (int i = 0; i < this.length; ++i) {
            this.setOrAppend(i, editor.apply(this.get(i)));
        }
        return this;
    }

    public A getSub(int beginInclude, int endExclude) {
        int length = this.length;
        if (beginInclude < 0) {
            beginInclude += length;
        }
        if (endExclude < 0) {
            endExclude += length;
        }
        if (beginInclude > endExclude) {
            int tmp = beginInclude;
            beginInclude = endExclude;
            endExclude = tmp;
        }
        if (beginInclude >= length) {
            return (A)Array.newInstance(this.componentType, 0);
        }
        if (endExclude > length) {
            endExclude = length;
        }
        Object result = Array.newInstance(this.componentType, endExclude - beginInclude);
        System.arraycopy(this.array, beginInclude, result, 0, endExclude - beginInclude);
        return (A)result;
    }

    public A getSub(int beginInclude, int endExclude, int step) {
        int length = this.length;
        if (beginInclude < 0) {
            beginInclude += length;
        }
        if (endExclude < 0) {
            endExclude += length;
        }
        if (beginInclude > endExclude) {
            int tmp = beginInclude;
            beginInclude = endExclude;
            endExclude = tmp;
        }
        if (beginInclude >= length) {
            return (A)Array.newInstance(this.componentType, 0);
        }
        if (endExclude > length) {
            endExclude = length;
        }
        if (step <= 1) {
            step = 1;
        }
        int size = (endExclude - beginInclude + step - 1) / step;
        Object result = Array.newInstance(this.componentType, size);
        int j = 0;
        for (int i = beginInclude; i < endExclude; i += step) {
            Array.set(result, j, this.get(i));
            ++j;
        }
        return (A)result;
    }

    public boolean isSorted(Comparator<E> comparator) {
        if (this.isEmpty()) {
            return false;
        }
        int lastIndex = this.length - 1;
        int cmp = comparator.compare(this.get(0), this.get(lastIndex));
        if (cmp < 0) {
            return this.isSorted(comparator, false);
        }
        if (cmp > 0) {
            return this.isSorted(comparator, true);
        }
        for (int i = 0; i < lastIndex; ++i) {
            if (comparator.compare(this.get(i), this.get(i + 1)) == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isSorted(Comparator<E> comparator, boolean isDESC) {
        if (null == comparator) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            int compare = comparator.compare(this.get(i), this.get(i + 1));
            if ((!isDESC || compare >= 0) && (isDESC || compare <= 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIter(this.array);
    }

    public String toString() {
        A array = this.array;
        if (null == array) {
            return null;
        }
        if (array instanceof long[]) {
            return Arrays.toString((long[])array);
        }
        if (array instanceof int[]) {
            return Arrays.toString((int[])array);
        }
        if (array instanceof short[]) {
            return Arrays.toString((short[])array);
        }
        if (array instanceof char[]) {
            return Arrays.toString((char[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.toString((byte[])array);
        }
        if (array instanceof boolean[]) {
            return Arrays.toString((boolean[])array);
        }
        if (array instanceof float[]) {
            return Arrays.toString((float[])array);
        }
        if (array instanceof double[]) {
            return Arrays.toString((double[])array);
        }
        if (ArrayUtil.isArray(array)) {
            try {
                return Arrays.deepToString((Object[])array);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return array.toString();
    }

    private void setNewArray(A newArray) {
        this.array = newArray;
        this.length = Array.getLength(newArray);
    }
}

