/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanDesc;
import org.dromara.hutool.core.bean.BeanDescCache;
import org.dromara.hutool.core.bean.BeanException;
import org.dromara.hutool.core.bean.BeanInfoCache;
import org.dromara.hutool.core.bean.BeanPath;
import org.dromara.hutool.core.bean.DynaBean;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.bean.copier.BeanCopier;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.bean.copier.ValueProvider;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.set.SetUtil;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.map.CaseInsensitiveMap;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class BeanUtil {
    public static boolean isReadableBean(Class<?> clazz) {
        return BeanUtil.hasGetter(clazz) || BeanUtil.hasPublicField(clazz);
    }

    public static boolean isBean(Class<?> clazz) {
        return BeanUtil.hasSetter(clazz) || BeanUtil.hasPublicField(clazz);
    }

    public static boolean hasSetter(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterCount() != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGetter(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                String name;
                if (method.getParameterCount() != 0 || !(name = method.getName()).startsWith("get") && !name.startsWith("is") || "getClass".equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicField(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Field field : clazz.getFields()) {
                if (!ModifierUtil.isPublic(field) || ModifierUtil.isStatic(field)) continue;
                return true;
            }
        }
        return false;
    }

    public static DynaBean createDynaBean(Object bean) {
        return new DynaBean(bean);
    }

    public static PropertyEditor findEditor(Class<?> type) {
        return PropertyEditorManager.findEditor(type);
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        return BeanDescCache.INSTANCE.getBeanDesc(clazz, () -> new BeanDesc(clazz));
    }

    public static void descForEach(Class<?> clazz, Consumer<? super PropDesc> action) {
        BeanUtil.getBeanDesc(clazz).getProps().forEach(action);
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws BeanException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new BeanException(e);
        }
        return ArrayUtil.filter(beanInfo.getPropertyDescriptors(), t -> !"class".equals(t.getName()));
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        return BeanInfoCache.INSTANCE.getPropertyDescriptorMap(clazz, ignoreCase, () -> BeanUtil.internalGetPropertyDescriptorMap(clazz, ignoreCase));
    }

    private static Map<String, PropertyDescriptor> internalGetPropertyDescriptorMap(Class<?> clazz, boolean ignoreCase) throws BeanException {
        PropertyDescriptor[] propertyDescriptors = BeanUtil.getPropertyDescriptors(clazz);
        CaseInsensitiveMap<String, PropertyDescriptor> map = ignoreCase ? new CaseInsensitiveMap(propertyDescriptors.length, 1.0f) : new HashMap(propertyDescriptors.length, 1.0f);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            map.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        return map;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName) throws BeanException {
        return BeanUtil.getPropertyDescriptor(clazz, fieldName, false);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String fieldName, boolean ignoreCase) throws BeanException {
        Map<String, PropertyDescriptor> map = BeanUtil.getPropertyDescriptorMap(clazz, ignoreCase);
        return null == map ? null : map.get(fieldName);
    }

    public static Object getFieldValue(Object bean, String fieldNameOrIndex) {
        if (null == bean || null == fieldNameOrIndex) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldNameOrIndex);
        }
        if (bean instanceof Collection) {
            try {
                return CollUtil.get((Collection)bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return CollUtil.map((Collection)bean, beanEle -> BeanUtil.getFieldValue(beanEle, fieldNameOrIndex), false);
            }
        }
        if (ArrayUtil.isArray(bean)) {
            try {
                return ArrayUtil.get(bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return ArrayUtil.map(bean, Object.class, beanEle -> BeanUtil.getFieldValue(beanEle, fieldNameOrIndex));
            }
        }
        return FieldUtil.getFieldValue(bean, fieldNameOrIndex);
    }

    public static Object setFieldValue(Object bean, String fieldNameOrIndex, Object value) {
        if (bean instanceof Map) {
            ((Map)bean).put(fieldNameOrIndex, value);
        } else if (bean instanceof List) {
            ListUtil.setOrPadding((List)bean, Convert.toInt(fieldNameOrIndex), value);
        } else {
            if (ArrayUtil.isArray(bean)) {
                return ArrayUtil.setOrAppend(bean, (int)Convert.toInt(fieldNameOrIndex), value);
            }
            FieldUtil.setFieldValue(bean, fieldNameOrIndex, value);
        }
        return bean;
    }

    public static <T> T getProperty(Object bean, String expression) {
        if (null == bean || StrUtil.isBlank(expression)) {
            return null;
        }
        return (T)BeanPath.of(expression).get(bean);
    }

    public static void setProperty(Object bean, String expression, Object value) {
        BeanPath.of(expression).set(bean, value);
    }

    public static <T> T mapToBean(Map<?, ?> map, Class<T> beanClass, boolean isToCamelCase, CopyOptions copyOptions) {
        return BeanUtil.fillBeanWithMap(map, ConstructorUtil.newInstanceIfPossible(beanClass), isToCamelCase, copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, bean, false, isIgnoreError);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, bean, isToCamelCase, CopyOptions.of().setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMapIgnoreCase(Map<?, ?> map, T bean, boolean isIgnoreError) {
        return BeanUtil.fillBeanWithMap(map, bean, CopyOptions.of().setIgnoreCase(true).setIgnoreError(isIgnoreError));
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, CopyOptions copyOptions) {
        return BeanUtil.fillBeanWithMap(map, bean, false, copyOptions);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, boolean isToCamelCase, CopyOptions copyOptions) {
        if (MapUtil.isEmpty(map)) {
            return bean;
        }
        if (isToCamelCase) {
            map = MapUtil.toCamelCaseMap(map);
        }
        BeanUtil.copyProperties(map, bean, copyOptions);
        return bean;
    }

    public static <T> T toBean(Object source, Class<T> clazz) {
        return BeanUtil.toBean(source, clazz, null);
    }

    public static <T> T toBean(Object source, Class<T> clazz, CopyOptions options) {
        return (T)BeanUtil.toBean(source, () -> ConstructorUtil.newInstanceIfPossible(clazz), options);
    }

    public static <T> T toBean(Object source, Supplier<T> targetSupplier, CopyOptions options) {
        if (null == source || null == targetSupplier) {
            return null;
        }
        T target = targetSupplier.get();
        BeanUtil.copyProperties(source, target, options);
        return target;
    }

    public static <T> T fillBean(T bean, ValueProvider<String> valueProvider, CopyOptions copyOptions) {
        if (null == valueProvider) {
            return bean;
        }
        return BeanCopier.of(valueProvider, bean, copyOptions).copy();
    }

    public static Map<String, Object> beanToMap(Object bean, String ... properties) {
        int mapSize = 16;
        UnaryOperator editor = null;
        if (ArrayUtil.isNotEmpty(properties)) {
            mapSize = properties.length;
            HashSet<String> propertiesSet = SetUtil.of(properties);
            editor = entry -> {
                String key = (String)entry.getKey();
                entry.setKey(propertiesSet.contains(key) ? key : null);
                return entry;
            };
        }
        return BeanUtil.beanToMap(bean, new LinkedHashMap<String, Object>(mapSize, 1.0f), false, editor);
    }

    public static Map<String, Object> beanToMap(Object bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return BeanUtil.beanToMap(bean, new LinkedHashMap<String, Object>(), isToUnderlineCase, ignoreNullValue);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == bean) {
            return null;
        }
        return BeanUtil.beanToMap(bean, targetMap, ignoreNullValue, entry -> {
            String key = (String)entry.getKey();
            entry.setKey(isToUnderlineCase ? StrUtil.toUnderlineCase(key) : key);
            return entry;
        });
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean ignoreNullValue, UnaryOperator<MutableEntry<String, Object>> keyEditor) {
        if (null == bean) {
            return null;
        }
        return BeanCopier.of(bean, targetMap, CopyOptions.of().setIgnoreNullValue(ignoreNullValue).setFieldEditor(keyEditor)).copy();
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, CopyOptions copyOptions) {
        if (null == bean) {
            return null;
        }
        return BeanCopier.of(bean, targetMap, copyOptions).copy();
    }

    public static <T> T copyProperties(Object source, Class<T> tClass, String ... ignoreProperties) {
        if (null == source) {
            return null;
        }
        T target = ConstructorUtil.newInstanceIfPossible(tClass);
        BeanUtil.copyProperties(source, target, CopyOptions.of().setIgnoreProperties(ignoreProperties));
        return target;
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) {
        BeanUtil.copyProperties(source, target, CopyOptions.of().setIgnoreProperties(ignoreProperties));
    }

    public static void copyProperties(Object source, Object target, boolean ignoreCase) {
        BeanCopier.of(source, target, CopyOptions.of().setIgnoreCase(ignoreCase)).copy();
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        if (null == source || null == target) {
            return;
        }
        BeanCopier.of(source, target, ObjUtil.defaultIfNull(copyOptions, CopyOptions::of)).copy();
    }

    public static <T> List<T> copyToList(Collection<?> collection, Class<T> targetType, CopyOptions copyOptions) {
        if (null == collection) {
            return null;
        }
        if (collection.isEmpty()) {
            return new ArrayList(0);
        }
        return collection.stream().map(source -> {
            Object target = ConstructorUtil.newInstanceIfPossible(targetType);
            BeanUtil.copyProperties(source, target, copyOptions);
            return target;
        }).collect(Collectors.toList());
    }

    public static <T> List<T> copyToList(Collection<?> collection, Class<T> targetType) {
        return BeanUtil.copyToList(collection, targetType, CopyOptions.of());
    }

    public static boolean isMatchName(Object bean, String beanClassName, boolean isSimple) {
        if (null == bean || StrUtil.isBlank(beanClassName)) {
            return false;
        }
        return ClassUtil.getClassName(bean, isSimple).equals(isSimple ? StrUtil.upperFirst(beanClassName) : beanClassName);
    }

    public static <T> T edit(T bean, UnaryOperator<Field> editor) {
        Field[] fields;
        if (bean == null) {
            return null;
        }
        for (Field field : fields = FieldUtil.getFields(bean.getClass())) {
            if (ModifierUtil.isStatic(field)) continue;
            editor.apply(field);
        }
        return bean;
    }

    public static <T> T trimStrFields(T bean, String ... ignoreFields) {
        return BeanUtil.edit(bean, field -> {
            String trimVal;
            String val;
            if (ignoreFields != null && ArrayUtil.containsIgnoreCase(ignoreFields, field.getName())) {
                return field;
            }
            if (String.class.equals(field.getType()) && null != (val = (String)FieldUtil.getFieldValue(bean, field)) && !val.equals(trimVal = StrUtil.trim(val))) {
                FieldUtil.setFieldValue(bean, field, (Object)trimVal);
            }
            return field;
        });
    }

    public static boolean isEmpty(Object bean, String ... ignoreFieldNames) {
        return !BeanUtil.isNotEmpty(bean, ignoreFieldNames);
    }

    public static boolean isNotEmpty(Object bean, String ... ignoreFieldNames) {
        if (null == bean) {
            return false;
        }
        return BeanUtil.checkBean(bean, field -> !ArrayUtil.contains(ignoreFieldNames, field.getName()) && null != FieldUtil.getFieldValue(bean, field));
    }

    public static boolean hasNullField(Object bean, String ... ignoreFieldNames) {
        return BeanUtil.checkBean(bean, field -> !ArrayUtil.contains(ignoreFieldNames, field.getName()) && null == FieldUtil.getFieldValue(bean, field));
    }

    public static boolean hasEmptyField(Object bean, String ... ignoreFieldNames) {
        return BeanUtil.checkBean(bean, field -> !ArrayUtil.contains(ignoreFieldNames, field.getName()) && StrUtil.isEmptyIfStr(FieldUtil.getFieldValue(bean, field)));
    }

    public static boolean checkBean(Object bean, Predicate<Field> predicate) {
        if (null == bean) {
            return true;
        }
        for (Field field : FieldUtil.getFields(bean.getClass())) {
            if (ModifierUtil.isStatic(field) || !predicate.test(field)) continue;
            return true;
        }
        return false;
    }

    public static String getFieldName(String getterOrSetterName) {
        if (getterOrSetterName.startsWith("get") || getterOrSetterName.startsWith("set")) {
            return StrUtil.removePreAndLowerFirst((CharSequence)getterOrSetterName, 3);
        }
        if (getterOrSetterName.startsWith("is")) {
            return StrUtil.removePreAndLowerFirst((CharSequence)getterOrSetterName, 2);
        }
        throw new IllegalArgumentException("Invalid Getter or Setter name: " + getterOrSetterName);
    }
}

