/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.iter.EnumerationIter;
import org.dromara.hutool.core.collection.partition.AvgPartition;
import org.dromara.hutool.core.collection.partition.Partition;
import org.dromara.hutool.core.collection.partition.RandomAccessAvgPartition;
import org.dromara.hutool.core.collection.partition.RandomAccessPartition;
import org.dromara.hutool.core.comparator.PinyinComparator;
import org.dromara.hutool.core.comparator.PropertyComparator;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.page.PageInfo;
import org.dromara.hutool.core.util.ObjUtil;

public class ListUtil {
    @SafeVarargs
    public static <T> ArrayList<T> of(T ... values) {
        if (ArrayUtil.isEmpty(values)) {
            return new ArrayList();
        }
        ArrayList arrayList = new ArrayList(values.length);
        Collections.addAll(arrayList, values);
        return arrayList;
    }

    @SafeVarargs
    public static <T> LinkedList<T> ofLinked(T ... values) {
        LinkedList list = new LinkedList();
        if (ArrayUtil.isNotEmpty(values)) {
            Collections.addAll(list, values);
        }
        return list;
    }

    public static <T> List<T> of(boolean isLinked) {
        return isLinked ? ListUtil.ofLinked(new Object[0]) : ListUtil.of(new Object[0]);
    }

    public static <T> List<T> of(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return ListUtil.of(isLinked);
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return isLinked ? new LinkedList(collection) : new ArrayList(collection);
        }
        return ListUtil.of(isLinked, iterable.iterator());
    }

    public static <T> List<T> of(boolean isLinked, Enumeration<T> enumration) {
        return ListUtil.of(isLinked, new EnumerationIter<T>(enumration));
    }

    public static <T> List<T> of(boolean isLinked, Iterator<T> iter) {
        List<T> list = ListUtil.of(isLinked);
        if (null != iter) {
            while (iter.hasNext()) {
                list.add(iter.next());
            }
        }
        return list;
    }

    public static <T> ArrayList<T> of(Iterable<T> iterable) {
        return (ArrayList)ListUtil.of(false, iterable);
    }

    public static <T> ArrayList<T> of(Iterator<T> iterator) {
        return (ArrayList)ListUtil.of(false, iterator);
    }

    public static <T> ArrayList<T> of(Enumeration<T> enumeration) {
        return (ArrayList)ListUtil.of(false, enumeration);
    }

    @SafeVarargs
    public static <T> List<T> view(T ... ts) {
        return ListUtil.view(ListUtil.of(ts));
    }

    public static <T> List<T> view(List<T> ts) {
        if (ArrayUtil.isEmpty(ts)) {
            return ListUtil.empty();
        }
        return Collections.unmodifiableList(ts);
    }

    public static <T> List<T> empty() {
        return Collections.emptyList();
    }

    public static <T> List<T> zero() {
        return new ArrayList(0);
    }

    public static <T> CopyOnWriteArrayList<T> ofCopyOnWrite(Collection<T> collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(collection);
    }

    @SafeVarargs
    public static <T> CopyOnWriteArrayList<T> ofCopyOnWrite(T ... ts) {
        return null == ts ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(ts);
    }

    public static <T> List<T> page(List<T> list, int pageNo, int pageSize) {
        if (CollUtil.isEmpty(list)) {
            return new ArrayList(0);
        }
        return ListUtil.page(list, PageInfo.of(list.size(), pageSize).setFirstPageNo(0).setPageNo(pageNo));
    }

    public static <T> List<T> page(List<T> list, PageInfo pageInfo) {
        int pageSize;
        if (CollUtil.isEmpty(list)) {
            return new ArrayList(0);
        }
        int total = list.size();
        if (total <= (pageSize = pageInfo.getPageSize())) {
            if (pageInfo.isFirstPage()) {
                return ListUtil.view(list);
            }
            return new ArrayList(0);
        }
        if (pageInfo.getBeginIndex() > total) {
            return new ArrayList(0);
        }
        return ListUtil.sub(list, pageInfo.getBeginIndex(), pageInfo.getEndIndexExclude());
    }

    public static <T> void page(List<T> list, int pageSize, Consumer<List<T>> pageListConsumer) {
        if (CollUtil.isEmpty(list) || pageSize <= 0) {
            return;
        }
        int total = list.size();
        PageInfo pageInfo = PageInfo.of(total, pageSize);
        while (pageInfo.isValidPage()) {
            pageListConsumer.accept(ListUtil.sub(list, pageInfo.getBeginIndex(), pageInfo.getEndIndexExclude()));
            pageInfo.nextPage();
        }
    }

    public static <T> List<T> sort(List<T> list) {
        return ListUtil.sort(list, null);
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        if (CollUtil.isEmpty(list)) {
            return list;
        }
        if (null == c) {
            c = Comparator.nullsFirst(Comparator.naturalOrder());
        }
        list.sort(c);
        return list;
    }

    public static <T> List<T> sortByProperty(List<T> list, String property) {
        return ListUtil.sort(list, new PropertyComparator(property));
    }

    public static List<String> sortByPinyin(List<String> list) {
        return ListUtil.sort(list, new PinyinComparator());
    }

    public static <T> List<T> reverse(List<T> list) {
        if (CollUtil.isEmpty(list)) {
            return list;
        }
        Collections.reverse(list);
        return list;
    }

    public static <T> List<T> reverseNew(List<T> list) {
        List<T> list2 = ObjUtil.clone(list);
        if (null == list2) {
            list2 = new ArrayList<T>(list);
        }
        try {
            return ListUtil.reverse(list2);
        }
        catch (UnsupportedOperationException e) {
            return ListUtil.reverse(ListUtil.of(list));
        }
    }

    public static <T> List<T> setOrAppend(List<T> list, int index, T element) {
        if (index < list.size()) {
            list.set(index, element);
        } else {
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> setOrPadding(List<T> list, int index, T element) {
        return ListUtil.setOrPadding(list, index, element, null);
    }

    public static <T> List<T> setOrPadding(List<T> list, int index, T element, T paddingElement) {
        Assert.notNull(list, "List must be not null !", new Object[0]);
        int size = list.size();
        if (index < size) {
            list.set(index, element);
        } else {
            for (int i = size; i < index; ++i) {
                list.add(paddingElement);
            }
            list.add(element);
        }
        return list;
    }

    public static <T> List<T> sub(List<T> list, int begionInclude, int endExclude) {
        return ListUtil.sub(list, begionInclude, endExclude, 1);
    }

    public static <T> List<T> sub(List<T> list, int begionInclude, int endExclude, int step) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return new ArrayList(0);
        }
        int size = list.size();
        if (begionInclude < 0) {
            begionInclude += size;
        }
        if (endExclude < 0) {
            endExclude += size;
        }
        if (begionInclude == size) {
            return new ArrayList(0);
        }
        if (begionInclude > endExclude) {
            int tmp = begionInclude;
            begionInclude = endExclude;
            endExclude = tmp;
        }
        if (endExclude > size) {
            if (begionInclude >= size) {
                return new ArrayList(0);
            }
            endExclude = size;
        }
        if (step < 1) {
            step = 1;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (int i = begionInclude; i < endExclude; i += step) {
            result.add(list.get(i));
        }
        return result;
    }

    public static <T> int lastIndexOf(List<T> list, Predicate<? super T> matcher) {
        int size;
        if (null != list && (size = list.size()) > 0) {
            for (int i = size - 1; i >= 0; --i) {
                if (null != matcher && !matcher.test(list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> List<List<T>> partition(List<T> list, int size) {
        if (CollUtil.isEmpty(list)) {
            return ListUtil.empty();
        }
        return list instanceof RandomAccess ? new RandomAccessPartition<T>(list, size) : new Partition<T>(list, size);
    }

    public static <T> List<List<T>> avgPartition(List<T> list, int limit) {
        if (CollUtil.isEmpty(list)) {
            return ListUtil.empty();
        }
        return list instanceof RandomAccess ? new RandomAccessAvgPartition<T>(list, limit) : new AvgPartition<T>(list, limit);
    }

    public static <T> void swapTo(List<T> list, T element, Integer targetIndex) {
        int index;
        if (CollUtil.isNotEmpty(list) && (index = list.indexOf(element)) >= 0) {
            Collections.swap(list, index, (int)targetIndex);
        }
    }

    public static <T> void swapElement(List<T> list, T element, T targetElement) {
        int targetIndex;
        if (CollUtil.isNotEmpty(list) && (targetIndex = list.indexOf(targetElement)) >= 0) {
            ListUtil.swapTo(list, element, targetIndex);
        }
    }

    public static <T> List<T> unmodifiable(List<? extends T> c) {
        if (null == c) {
            return null;
        }
        return Collections.unmodifiableList(c);
    }

    public static <T> List<T> addAllIfNotContains(List<T> list, List<T> otherList) {
        for (T t : otherList) {
            if (list.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    @SafeVarargs
    public static <T> List<T> splice(List<T> list, int start, int deleteCount, T ... items) {
        if (CollUtil.isEmpty(list)) {
            return ListUtil.zero();
        }
        int size = list.size();
        if (start < 0) {
            start += size;
        } else if (start >= size) {
            start = size;
            deleteCount = 0;
        }
        if (start + deleteCount > size) {
            deleteCount = size - start;
        }
        int newSize = size - deleteCount + items.length;
        List<T> resList = list;
        if (newSize > size) {
            resList = new ArrayList<T>(newSize);
            resList.addAll(list);
        }
        if (deleteCount > 0) {
            resList.subList(start, start + deleteCount).clear();
        }
        if (ArrayUtil.isNotEmpty(items)) {
            resList.addAll(start, Arrays.asList(items));
        }
        return resList;
    }
}

