/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.compress;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.dromara.hutool.core.compress.ZipResource;
import org.dromara.hutool.core.compress.ZipSecurityUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;

public class ZipStreamResource
implements ZipResource {
    private final ZipInputStream in;

    public ZipStreamResource(ZipInputStream in) {
        this.in = in;
    }

    @Override
    public void read(Consumer<ZipEntry> consumer, int maxSizeDiff) {
        try {
            ZipEntry zipEntry;
            while (null != (zipEntry = this.in.getNextEntry())) {
                consumer.accept(zipEntry);
                ZipSecurityUtil.checkZipBomb(zipEntry, maxSizeDiff);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public InputStream get(String path) {
        try {
            ZipEntry zipEntry;
            this.in.reset();
            while (null != (zipEntry = this.in.getNextEntry())) {
                if (!zipEntry.getName().equals(path)) continue;
                return this.in;
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return null;
    }

    @Override
    public InputStream get(ZipEntry entry) {
        return this.in;
    }

    @Override
    public void close() throws IOException {
        IoUtil.closeQuietly(this.in);
    }
}

