/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.dromara.hutool.core.convert.AbstractConverter;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.text.StrUtil;

public class DateConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;
    public static final DateConverter INSTANCE = new DateConverter();
    private String format;

    public DateConverter() {
        this(null);
    }

    public DateConverter(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Class<?> targetClass, Object value) {
        DateTime dateTime;
        if (value == null || value instanceof CharSequence && StrUtil.isBlank(value.toString())) {
            return null;
        }
        if (value instanceof TemporalAccessor) {
            return this.wrap(targetClass, DateUtil.date((TemporalAccessor)value));
        }
        if (value instanceof Calendar) {
            return this.wrap(targetClass, DateUtil.date((Calendar)value));
        }
        if (null == this.format && value instanceof Number) {
            return this.wrap(targetClass, ((Number)value).longValue());
        }
        String valueStr = this.convertToStr(value);
        DateTime dateTime2 = dateTime = StrUtil.isBlank(this.format) ? DateUtil.parse(valueStr) : DateUtil.parse((CharSequence)valueStr, this.format);
        if (null != dateTime) {
            return this.wrap(targetClass, dateTime);
        }
        throw new ConvertException("Can not convert {}:[{}] to {}", value.getClass().getName(), value, targetClass.getName());
    }

    private Date wrap(Class<?> targetClass, DateTime date) {
        if (Date.class == targetClass) {
            return date.toJdkDate();
        }
        if (DateTime.class == targetClass) {
            return date;
        }
        if (java.sql.Date.class == targetClass) {
            return date.toSqlDate();
        }
        if (Time.class == targetClass) {
            return new Time(date.getTime());
        }
        if (Timestamp.class == targetClass) {
            return date.toTimestamp();
        }
        throw new UnsupportedOperationException(StrUtil.format("Unsupported target Date type: {}", targetClass.getName()));
    }

    private Date wrap(Class<?> targetClass, long mills) {
        if (Date.class == targetClass) {
            return new Date(mills);
        }
        if (DateTime.class == targetClass) {
            return DateUtil.date(mills);
        }
        if (java.sql.Date.class == targetClass) {
            return new java.sql.Date(mills);
        }
        if (Time.class == targetClass) {
            return new Time(mills);
        }
        if (Timestamp.class == targetClass) {
            return new Timestamp(mills);
        }
        throw new UnsupportedOperationException(StrUtil.format("Unsupported target Date type: {}", targetClass.getName()));
    }
}

