/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.date;

import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.TimeZone;
import java.util.function.Function;
import org.dromara.hutool.core.date.DatePattern;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.date.LocalTimeUtil;
import org.dromara.hutool.core.date.TemporalAccessorUtil;
import org.dromara.hutool.core.date.TemporalUtil;
import org.dromara.hutool.core.date.Week;
import org.dromara.hutool.core.date.ZoneUtil;
import org.dromara.hutool.core.date.format.GlobalCustomFormat;
import org.dromara.hutool.core.func.LambdaUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class TimeUtil
extends TemporalAccessorUtil {
    public static LocalDateTime now() {
        return LocalDateTime.now();
    }

    public static LocalDate today() {
        return LocalDate.now();
    }

    public static LocalDateTime ofUTC(Instant instant) {
        return TimeUtil.of(instant, ZoneUtil.ZONE_ID_UTC);
    }

    public static LocalDateTime of(Instant instant, ZoneId zoneId) {
        if (null == instant) {
            return null;
        }
        return LocalDateTime.ofInstant(instant, ObjUtil.defaultIfNull(zoneId, ZoneId::systemDefault));
    }

    public static LocalDateTime of(Instant instant, TimeZone timeZone) {
        if (null == instant) {
            return null;
        }
        return TimeUtil.of(instant, ObjUtil.defaultIfNull(timeZone, TimeZone::getDefault).toZoneId());
    }

    public static LocalDateTime of(long epochMilli) {
        return TimeUtil.of(Instant.ofEpochMilli(epochMilli));
    }

    public static LocalDateTime ofUTC(long epochMilli) {
        return TimeUtil.ofUTC(Instant.ofEpochMilli(epochMilli));
    }

    public static LocalDateTime of(long epochMilli, ZoneId zoneId) {
        return TimeUtil.of(Instant.ofEpochMilli(epochMilli), zoneId);
    }

    public static LocalDateTime of(long epochMilli, TimeZone timeZone) {
        return TimeUtil.of(Instant.ofEpochMilli(epochMilli), timeZone);
    }

    public static LocalDateTime of(Date date) {
        if (null == date) {
            return null;
        }
        if (date instanceof DateTime) {
            return TimeUtil.of(date.toInstant(), ((DateTime)date).getZoneId());
        }
        return TimeUtil.of(date.toInstant());
    }

    public static LocalDateTime of(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDate) {
            return ((LocalDate)temporalAccessor).atStartOfDay();
        }
        if (temporalAccessor instanceof Instant) {
            return LocalDateTime.ofInstant((Instant)temporalAccessor, ZoneId.systemDefault());
        }
        if (temporalAccessor instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporalAccessor).toLocalDateTime();
        }
        return LocalDateTime.of(TemporalAccessorUtil.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.DAY_OF_MONTH), TemporalAccessorUtil.get(temporalAccessor, ChronoField.HOUR_OF_DAY), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MINUTE_OF_HOUR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.SECOND_OF_MINUTE), TemporalAccessorUtil.get(temporalAccessor, ChronoField.NANO_OF_SECOND));
    }

    public static LocalDate ofDate(TemporalAccessor temporalAccessor) {
        if (null == temporalAccessor) {
            return null;
        }
        if (temporalAccessor instanceof LocalDateTime) {
            return ((LocalDateTime)temporalAccessor).toLocalDate();
        }
        if (temporalAccessor instanceof Instant) {
            return TimeUtil.of(temporalAccessor).toLocalDate();
        }
        return LocalDate.of(TemporalAccessorUtil.get(temporalAccessor, ChronoField.YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.MONTH_OF_YEAR), TemporalAccessorUtil.get(temporalAccessor, ChronoField.DAY_OF_MONTH));
    }

    public static LocalDateTime parseByISO(CharSequence text) {
        if (StrUtil.contains(text, 'T')) {
            return TimeUtil.parse(text, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        return TimeUtil.parse(text, DatePattern.NORM_DATETIME_FORMATTER);
    }

    public static LocalDateTime parse(CharSequence text, DateTimeFormatter formatter) {
        if (StrUtil.isBlank(text)) {
            return null;
        }
        if (null == formatter) {
            return LocalDateTime.parse(text);
        }
        return TimeUtil.of(formatter.parse(text));
    }

    public static LocalDateTime parse(CharSequence text, String format) {
        if (StrUtil.isBlank(text)) {
            return null;
        }
        if (GlobalCustomFormat.isCustomFormat(format)) {
            return TimeUtil.of(GlobalCustomFormat.parse(text, format));
        }
        DateTimeFormatter formatter = null;
        if (StrUtil.isNotBlank(format)) {
            if (StrUtil.startWithIgnoreEquals(format, "yyyyMMddHHmmss") && format.endsWith("S")) {
                int paddingWidth = 3 - (format.length() - "yyyyMMddHHmmss".length());
                if (paddingWidth > 0) {
                    text = text + StrUtil.repeat('0', paddingWidth);
                }
                formatter = DatePattern.PURE_DATETIME_MS_FORMATTER;
            } else {
                formatter = DateTimeFormatter.ofPattern(format);
            }
        }
        return TimeUtil.parse(text, formatter);
    }

    public static LocalDate parseDateByISO(CharSequence text) {
        return TimeUtil.parseDate(text, (DateTimeFormatter)null);
    }

    public static LocalDate parseDate(CharSequence text, DateTimeFormatter formatter) {
        if (null == text) {
            return null;
        }
        if (null == formatter) {
            return LocalDate.parse(text);
        }
        return TimeUtil.ofDate(formatter.parse(text));
    }

    public static LocalDate parseDate(CharSequence text, String format) {
        if (null == text) {
            return null;
        }
        return TimeUtil.parseDate(text, DateTimeFormatter.ofPattern(format));
    }

    public static String formatNormal(ChronoLocalDateTime<?> time) {
        return TimeUtil.format(time, DatePattern.NORM_DATETIME_FORMATTER);
    }

    public static String formatNormal(ChronoLocalDate date) {
        return TimeUtil.format((TemporalAccessor)date, DatePattern.NORM_DATE_FORMATTER);
    }

    public static Function<TemporalAccessor, String> formatFunc(DateTimeFormatter dateTimeFormatter) {
        return LambdaUtil.toFunction(TemporalAccessorUtil::format, dateTimeFormatter);
    }

    public static LocalDateTime offset(LocalDateTime time, long number, TemporalUnit field) {
        return TemporalUtil.offset(time, number, field);
    }

    public static Duration between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude) {
        return TemporalUtil.between(startTimeInclude, endTimeExclude);
    }

    public static long between(LocalDateTime startTimeInclude, LocalDateTime endTimeExclude, ChronoUnit unit) {
        return TemporalUtil.between(startTimeInclude, endTimeExclude, unit);
    }

    public static Period betweenPeriod(LocalDate startTimeInclude, LocalDate endTimeExclude) {
        return Period.between(startTimeInclude, endTimeExclude);
    }

    public static LocalDateTime beginOfDay(LocalDateTime time) {
        return time.with(LocalTime.MIN);
    }

    public static LocalDateTime endOfDay(LocalDateTime time, boolean truncateMillisecond) {
        return time.with(LocalTimeUtil.max(truncateMillisecond));
    }

    public static LocalDateTime beginOfMonth(LocalDateTime time) {
        return TimeUtil.beginOfDay(time).with(TemporalAdjusters.firstDayOfMonth());
    }

    public static LocalDateTime endOfMonth(LocalDateTime time, boolean truncateMillisecond) {
        return TimeUtil.endOfDay(time, truncateMillisecond).with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDateTime beginOfYear(LocalDateTime time) {
        return TimeUtil.beginOfDay(time).with(TemporalAdjusters.firstDayOfYear());
    }

    public static LocalDateTime endOfYear(LocalDateTime time, boolean truncateMillisecond) {
        return TimeUtil.endOfDay(time, truncateMillisecond).with(TemporalAdjusters.lastDayOfYear());
    }

    public static boolean isWeekend(LocalDateTime localDateTime) {
        return TimeUtil.isWeekend(localDateTime.toLocalDate());
    }

    public static boolean isWeekend(LocalDate localDate) {
        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        return DayOfWeek.SATURDAY == dayOfWeek || DayOfWeek.SUNDAY == dayOfWeek;
    }

    public static Week dayOfWeek(LocalDate localDate) {
        return Week.of(localDate.getDayOfWeek());
    }

    public static boolean isOverlap(ChronoLocalDateTime<?> realStartTime, ChronoLocalDateTime<?> realEndTime, ChronoLocalDateTime<?> startTime, ChronoLocalDateTime<?> endTime) {
        return realStartTime.compareTo(endTime) <= 0 && startTime.compareTo(realEndTime) <= 0;
    }

    public static int weekOfYear(TemporalAccessor date) {
        return TemporalAccessorUtil.get(date, WeekFields.ISO.weekOfYear());
    }

    public static boolean isSameDay(ChronoLocalDateTime<?> date1, ChronoLocalDateTime<?> date2) {
        return date1 != null && date2 != null && date1.toLocalDate().isEqual((ChronoLocalDate)date2.toLocalDate());
    }

    public static boolean isSameDay(ChronoLocalDate date1, ChronoLocalDate date2) {
        return date1 != null && date2 != null && date1.isEqual(date2);
    }
}

